/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity.energy;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import sonar.fluxnetworks.api.energy.FNEnergyCapability;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.common.core.DefaultEnergyWrapper;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public abstract class TileDefaultEnergy
extends TileFluxCore
implements IFluxConnector {
    public Map<Direction, DefaultEnergyWrapper> wrappers = new HashMap<Direction, DefaultEnergyWrapper>();

    public TileDefaultEnergy(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.wrappers.put(null, new DefaultEnergyWrapper(this, null));
        for (Direction face : Direction.values()) {
            this.wrappers.put(face, new DefaultEnergyWrapper(this, face));
        }
    }

    public DefaultEnergyWrapper getEnergyWrapper(Direction facing) {
        return this.wrappers.get(facing);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == FNEnergyCapability.FN_ENERGY_STORAGE) {
            return LazyOptional.of(() -> this.getEnergyWrapper(side)).cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.getEnergyWrapper(side)).cast();
        }
        return super.getCapability(cap, side);
    }
}

