/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.energy.FNEnergyCapability;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.client.render.ItemRendererCallable;
import sonar.fluxnetworks.common.block.FluxControllerBlock;
import sonar.fluxnetworks.common.block.FluxPlugBlock;
import sonar.fluxnetworks.common.block.FluxPointBlock;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.capability.SuperAdminInstance;
import sonar.fluxnetworks.common.core.ContainerConnector;
import sonar.fluxnetworks.common.core.FireItemEntity;
import sonar.fluxnetworks.common.handler.CapabilityHandler;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.handler.TileEntityHandler;
import sonar.fluxnetworks.common.item.AdminConfiguratorItem;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;
import sonar.fluxnetworks.common.item.FluxConnectorBlockItem;
import sonar.fluxnetworks.common.item.FluxItem;
import sonar.fluxnetworks.common.recipes.FluxStorageRecipeSerializer;
import sonar.fluxnetworks.common.recipes.NBTWipeRecipeSerializer;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;
import sonar.fluxnetworks.common.registry.RegistrySounds;
import sonar.fluxnetworks.common.tileentity.TileFluxController;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;
import sonar.fluxnetworks.common.tileentity.TileFluxPoint;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

@Mod.EventBusSubscriber(modid="fluxnetworks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonRegistration {
    public static final ItemGroup ITEM_GROUP = new ItemGroup("fluxnetworks"){

        @Nonnull
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RegistryItems.FLUX_CORE);
        }
    };

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        FluxNetworks.LOGGER.info("Started Common Setup");
        FNEnergyCapability.register();
        PacketHandler.registerMessages();
        TileEntityHandler.registerEnergyHandler();
        SuperAdminInstance.register();
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
        FluxNetworks.LOGGER.info("Finished Common Setup");
    }

    @SubscribeEvent
    public static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        FluxNetworks.LOGGER.info("Started Registering Blocks");
        Block.Properties normalProps = Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.0f, 1000.0f);
        Block.Properties connectorProps = Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.0f, 1000.0f).func_226896_b_();
        event.getRegistry().register(new Block(normalProps).setRegistryName("fluxblock"));
        event.getRegistry().register(new FluxPlugBlock(connectorProps).setRegistryName("fluxplug"));
        event.getRegistry().register(new FluxPointBlock(connectorProps).setRegistryName("fluxpoint"));
        event.getRegistry().register(new FluxControllerBlock(connectorProps).setRegistryName("fluxcontroller"));
        event.getRegistry().register(new FluxStorageBlock.Basic(connectorProps).setRegistryName("basicfluxstorage"));
        event.getRegistry().register(new FluxStorageBlock.Herculean(connectorProps).setRegistryName("herculeanfluxstorage"));
        event.getRegistry().register(new FluxStorageBlock.Gargantuan(connectorProps).setRegistryName("gargantuanfluxstorage"));
        FluxNetworks.LOGGER.info("Finished Registering Blocks");
    }

    @SubscribeEvent
    public static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        FluxNetworks.LOGGER.info("Started Registering Items");
        Item.Properties props = new Item.Properties().func_200916_a(ITEM_GROUP);
        event.getRegistry().register(new BlockItem(RegistryBlocks.FLUX_BLOCK, props).setRegistryName("fluxblock"));
        event.getRegistry().register(new FluxConnectorBlockItem(RegistryBlocks.FLUX_PLUG, props).setRegistryName("fluxplug"));
        event.getRegistry().register(new FluxConnectorBlockItem(RegistryBlocks.FLUX_POINT, props).setRegistryName("fluxpoint"));
        event.getRegistry().register(new FluxConnectorBlockItem(RegistryBlocks.FLUX_CONTROLLER, props).setRegistryName("fluxcontroller"));
        Item.Properties storageProps = new Item.Properties().func_200916_a(ITEM_GROUP).setISTER(ItemRendererCallable::getStorageRenderer);
        event.getRegistry().register(new FluxConnectorBlockItem(RegistryBlocks.BASIC_FLUX_STORAGE, storageProps).setRegistryName("basicfluxstorage"));
        event.getRegistry().register(new FluxConnectorBlockItem(RegistryBlocks.HERCULEAN_FLUX_STORAGE, storageProps).setRegistryName("herculeanfluxstorage"));
        event.getRegistry().register(new FluxConnectorBlockItem(RegistryBlocks.GARGANTUAN_FLUX_STORAGE, storageProps).setRegistryName("gargantuanfluxstorage"));
        event.getRegistry().register(new FluxItem(props).setRegistryName("flux"));
        event.getRegistry().register(new Item(props).setRegistryName("fluxcore"));
        event.getRegistry().register(new FluxConfiguratorItem(props).setRegistryName("fluxconfigurator"));
        event.getRegistry().register(new AdminConfiguratorItem(props).setRegistryName("adminconfigurator"));
        FluxNetworks.LOGGER.info("Finished Registering Items");
    }

    @SubscribeEvent
    public static void onEntityRegistry(@Nonnull RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().register(EntityType.Builder.func_220322_a(FireItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_206830_a("fireitem").setRegistryName("fireitem"));
    }

    @SubscribeEvent
    public static void onTileEntityRegistry(@Nonnull RegistryEvent.Register<TileEntityType<?>> event) {
        FluxNetworks.LOGGER.info("Started Registering Tile Entities");
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(TileFluxPlug::new, (Block[])new Block[]{RegistryBlocks.FLUX_PLUG}).func_206865_a(null).setRegistryName("fluxplug"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(TileFluxPoint::new, (Block[])new Block[]{RegistryBlocks.FLUX_POINT}).func_206865_a(null).setRegistryName("fluxpoint"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(TileFluxController::new, (Block[])new Block[]{RegistryBlocks.FLUX_CONTROLLER}).func_206865_a(null).setRegistryName("fluxcontroller"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(TileFluxStorage.Basic::new, (Block[])new Block[]{RegistryBlocks.BASIC_FLUX_STORAGE}).func_206865_a(null).setRegistryName("basicfluxstorage"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(TileFluxStorage.Herculean::new, (Block[])new Block[]{RegistryBlocks.HERCULEAN_FLUX_STORAGE}).func_206865_a(null).setRegistryName("herculeanfluxstorage"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(TileFluxStorage.Gargantuan::new, (Block[])new Block[]{RegistryBlocks.GARGANTUAN_FLUX_STORAGE}).func_206865_a(null).setRegistryName("gargantuanfluxstorage"));
        FluxNetworks.LOGGER.info("Finished Registering Tile Entities");
    }

    @SubscribeEvent
    public static void onContainerRegistry(@Nonnull RegistryEvent.Register<ContainerType<?>> event) {
        FluxNetworks.LOGGER.info("Started Registering Containers");
        event.getRegistry().register(IForgeContainerType.create((windowId, inventory, packet) -> {
            if (packet.readBoolean()) {
                BlockPos pos = packet.func_179259_c();
                TileEntity tile = inventory.field_70458_d.func_130014_f_().func_175625_s(pos);
                if (tile instanceof INetworkConnector) {
                    return new ContainerConnector<INetworkConnector>(windowId, inventory, (INetworkConnector)tile);
                }
            } else {
                ItemStack stack = inventory.field_70458_d.func_184614_ca();
                if (stack.func_77973_b() instanceof AdminConfiguratorItem) {
                    return new ContainerConnector<AdminConfiguratorItem.ContainerProvider>(windowId, inventory, new AdminConfiguratorItem.ContainerProvider(stack));
                }
                if (stack.func_77973_b() instanceof FluxConfiguratorItem) {
                    return new ContainerConnector<FluxConfiguratorItem.ContainerProvider>(windowId, inventory, new FluxConfiguratorItem.ContainerProvider(stack));
                }
            }
            return null;
        }).setRegistryName("connector"));
        FluxNetworks.LOGGER.info("Finished Registering Containers");
    }

    @SubscribeEvent
    public static void registerRecipes(@Nonnull RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().register(FluxStorageRecipeSerializer.INSTANCE.setRegistryName("fluxnetworks", "fluxstoragerecipe"));
        event.getRegistry().register(NBTWipeRecipeSerializer.INSTANCE.setRegistryName("fluxnetworks", "nbtwiperecipe"));
    }

    @SubscribeEvent
    public static void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        RegistrySounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
    }
}

