/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BigRedMushroomFeature;

public class BOPBigRedMushroomFeature
extends BigRedMushroomFeature {
    public BOPBigRedMushroomFeature(Function<Dynamic<?>, ? extends BigMushroomFeatureConfig> deserializer) {
        super(deserializer);
    }

    protected void func_227210_a_(IWorld world, Random random, BlockPos pos, BigMushroomFeatureConfig config, int height, BlockPos.Mutable mutablePos) {
        for (int i = 0; i < height; ++i) {
            mutablePos.func_189533_g((Vec3i)pos).func_189534_c(Direction.UP, i);
            if (!world.func_180495_p((BlockPos)mutablePos).canBeReplacedByLeaves((IWorldReader)world, (BlockPos)mutablePos)) continue;
            this.func_202278_a((IWorldWriter)world, (BlockPos)mutablePos, config.field_227273_b_.func_225574_a_(random, pos));
        }
    }

    protected void func_225564_a_(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutablePos, BigMushroomFeatureConfig config) {
        for (int y = height - 3; y <= height; ++y) {
            int radius = y < height ? config.field_227274_c_ : config.field_227274_c_ - 1;
            int innerRadius = config.field_227274_c_ - 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean northOrSouthEdge;
                    boolean westEdge = x == -radius;
                    boolean eastEdge = x == radius;
                    boolean northEdge = z == -radius;
                    boolean southEdge = z == radius;
                    boolean eastOrWestEdge = westEdge || eastEdge;
                    boolean bl = northOrSouthEdge = northEdge || southEdge;
                    if (y < height && eastOrWestEdge == northOrSouthEdge) continue;
                    mutablePos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z);
                    if (!world.func_180495_p((BlockPos)mutablePos).canBeReplacedByLeaves((IWorldReader)world, (BlockPos)mutablePos)) continue;
                    this.func_202278_a((IWorldWriter)world, (BlockPos)mutablePos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.field_227272_a_.func_225574_a_(random, pos).func_206870_a((IProperty)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(y >= height - 1))).func_206870_a((IProperty)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(x < -innerRadius))).func_206870_a((IProperty)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(x > innerRadius))).func_206870_a((IProperty)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(z < -innerRadius))).func_206870_a((IProperty)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(z > innerRadius)));
                }
            }
        }
    }

    protected boolean func_227209_a_(IWorld world, BlockPos pos, int height, BlockPos.Mutable mutablePos, BigMushroomFeatureConfig config) {
        int i = pos.func_177956_o();
        if (i >= 1 && i + height + 1 < world.getMaxHeight()) {
            Block groundBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (!BOPBigRedMushroomFeature.func_227250_b_((Block)groundBlock) && groundBlock != Blocks.field_150424_aL && groundBlock != Blocks.field_150425_aM) {
                return false;
            }
            for (int y = 0; y <= height; ++y) {
                int radius = this.func_225563_a_(-1, -1, config.field_227274_c_, y);
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockState obstructingState = world.func_180495_p((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z));
                        if (obstructingState.isAir((IBlockReader)world, (BlockPos)mutablePos) || obstructingState.func_203425_a(BlockTags.field_206952_E)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

