/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.blocks;

import com.teamabnormals.upgrade_aquatic.common.tileentities.TileEntityBedroll;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBedroll
extends BedBlock
implements IBucketPickupHandler,
ILiquidContainer {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private final DyeColor color;

    public BlockBedroll(DyeColor colorIn, Block.Properties builder) {
        super(colorIn, builder);
        this.color = colorIn;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public MaterialColor func_180659_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177229_b(PART) == BedPart.FOOT ? this.color.func_196055_e() : MaterialColor.field_151659_e;
    }

    @Nullable
    private PlayerEntity getPlayerInBed(World worldIn, BlockPos pos) {
        for (PlayerEntity entityplayer : worldIn.func_217369_A()) {
            if (!entityplayer.func_70608_bn() || !entityplayer.func_180470_cg().equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.2f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_213453_ef()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.func_213322_ci().field_72448_b < 0.0) {
            entityIn.func_213293_j(entityIn.func_213322_ci().field_72450_a, -entityIn.func_213322_ci().field_72448_b * (double)0.66f, entityIn.func_213322_ci().field_72449_c);
            if (!(entityIn instanceof LivingEntity)) {
                entityIn.func_213293_j(entityIn.func_213322_ci().field_72450_a, entityIn.func_213322_ci().field_72448_b * (double)0.3f, entityIn.func_213322_ci().field_72449_c);
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing == BlockBedroll.func_208070_a((BedPart)stateIn.func_177229_b(PART), (Direction)stateIn.func_177229_b((IProperty)field_185512_D))) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? (BlockState)stateIn.func_206870_a((IProperty)OCCUPIED, facingState.func_177229_b((IProperty)OCCUPIED)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static Direction func_208070_a(BedPart p_208070_0_, Direction p_208070_1_) {
        return p_208070_0_ == BedPart.FOOT ? p_208070_1_ : p_208070_1_.func_176734_d();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            worldIn.func_175713_t(pos);
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BedPart bedpart = (BedPart)state.func_177229_b(PART);
        BlockPos blockpos = pos.func_177972_a(BlockBedroll.getDirectionToOther(bedpart, (Direction)state.func_177229_b((IProperty)field_185512_D)));
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(PART) != bedpart) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                ItemStack itemstack = player.func_184614_ca();
                BlockBedroll.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
            }
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    private static Direction getDirectionToOther(BedPart p_208070_0_, Direction p_208070_1_) {
        return p_208070_0_ == BedPart.FOOT ? p_208070_1_ : p_208070_1_.func_176734_d();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction enumfacing = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
        if (context.func_195991_k().func_180495_p(blockpos).func_177230_c() == Blocks.field_150355_j) {
            return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)enumfacing)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)) : null;
        }
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)enumfacing)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)) : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomBreakingProgress(BlockState state) {
        return true;
    }

    @Nullable
    public static BlockPos getSafeExitLocation(IBlockReader worldIn, BlockPos pos, int tries) {
        Direction enumfacing = (Direction)worldIn.func_180495_p(pos).func_177229_b((IProperty)field_185512_D);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockBedroll.hasRoomForPlayer(worldIn, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    protected static boolean hasRoomForPlayer(IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_200132_m() && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, PART, OCCUPIED, WATERLOGGED});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityBedroll(this.color);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)field_185512_D));
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.func_195592_c(pos, Blocks.field_150350_a);
            state.func_196946_a((IWorld)worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public DyeColor func_196350_d() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.func_177967_a((Direction)state.func_177229_b((IProperty)field_185512_D), state.func_177229_b(PART) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)pos.func_177956_o(), (int)blockpos.func_177952_p());
    }
}

