/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.blocks.coralstone;

import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CoralWallFanBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockCoralstone
extends Block {
    @Nullable
    private Block[] growableCoralBlocks;
    private boolean chiseled;
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");

    public BlockCoralstone(Block.Properties properties, boolean chiseled) {
        this(properties, chiseled, null);
    }

    public BlockCoralstone(Block.Properties properties, boolean chiseled, @Nullable Block[] growableCoralBlocks) {
        super(properties);
        this.chiseled = chiseled;
        this.growableCoralBlocks = growableCoralBlocks;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151097_aZ && state.func_177230_c() != UABlocks.CHISELED_CORALSTONE.get() && state.func_177230_c() != UABlocks.CORALSTONE.get()) {
            BlockState newState = this.chiseled ? ((Block)UABlocks.CHISELED_CORALSTONE.get()).func_176223_P() : ((Block)UABlocks.CORALSTONE.get()).func_176223_P();
            world.func_184133_a(null, pos, SoundEvents.field_187784_dt, SoundCategory.PLAYERS, 1.0f, 0.8f);
            stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            world.func_180501_a(pos, newState, 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        Block block = state.func_177230_c();
        if (this.growableCoralBlocks == null && block != UABlocks.DEAD_CORALSTONE.get() && block != UABlocks.DEAD_CHISELED_CORALSTONE.get()) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (this.chiseled) {
                    UABlocks.CHISELED_CORALSTONE_CONVERSION_MAP.forEach((input, output) -> {
                        if (input.get() == worldIn.func_180495_p(blockpos).func_177230_c()) {
                            worldIn.func_180501_a(pos, ((Block)output.get()).func_176223_P(), 2);
                        }
                    });
                    continue;
                }
                UABlocks.CORALSTONE_CONVERSION_MAP.forEach((input, output) -> {
                    if (input.get() == worldIn.func_180495_p(blockpos).func_177230_c()) {
                        worldIn.func_180501_a(pos, ((Block)output.get()).func_176223_P(), 2);
                    }
                });
            }
        }
        if (this.growableCoralBlocks != null && random.nextFloat() < 0.12f) {
            boolean isValidPosToGrow;
            Direction randDirection = this.growableCoralBlocks.length > 3 ? Direction.func_176741_a((Random)random) : Direction.func_82600_a((int)(random.nextInt(5) + 1));
            BlockPos growPos = pos.func_177972_a(randDirection);
            IFluidState fluidState = worldIn.func_180495_p(growPos).func_204520_s();
            boolean bl = isValidPosToGrow = worldIn.func_180495_p(growPos).func_185904_a().func_76222_j() && fluidState.func_206882_g() >= 8 && fluidState.func_206884_a(FluidTags.field_206959_a);
            if (isValidPosToGrow && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                if (randDirection.func_176745_a() > 1) {
                    worldIn.func_180501_a(growPos, (BlockState)this.growableCoralBlocks[2].func_176223_P().func_206870_a((IProperty)CoralWallFanBlock.field_211884_b, (Comparable)randDirection), 2);
                } else if (randDirection.func_176745_a() == 1) {
                    if (random.nextBoolean()) {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[1].func_176223_P(), 2);
                    } else {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[0].func_176223_P(), 2);
                    }
                } else {
                    worldIn.func_180501_a(growPos, this.growableCoralBlocks[3].func_176223_P(), 2);
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED});
    }
}

