/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.teamabnormals.abnormals_core.core.library.api.IAddToBiomes;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockMulberryVine;
import com.teamabnormals.upgrade_aquatic.common.world.gen.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.IPlantable;

public class FeatureRiverTree
extends TreeFeature
implements IAddToBiomes {
    public static final TreeFeatureConfig RIVER_TREE_CONFIG = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UABlocks.RIVER_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UABlocks.RIVER_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(0, 0)).setSapling((IPlantable)UABlocks.RIVER_SAPLING.get()).func_225568_b_();

    public FeatureRiverTree(Function<Dynamic<?>, ? extends TreeFeatureConfig> config) {
        super(config);
    }

    public boolean func_225557_a_(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> logsPlaced, Set<BlockPos> leavesPlaced, MutableBoundingBox boundsIn, TreeFeatureConfig config) {
        int height = 3 + rand.nextInt(2) + rand.nextInt(2);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (FeatureRiverTree.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (FeatureRiverTree.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)config.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight()) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                int logY = position.func_177956_o();
                for (int k1 = 0; k1 < height; ++k1) {
                    logY = position.func_177956_o() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (!FeatureRiverTree.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                    this.placeLogAt(logsPlaced, (IWorldWriter)worldIn, blockpos, boundsIn);
                }
                logY = position.func_177956_o() + height - rand.nextInt(2);
                position = new BlockPos(logX, logY, logZ);
                this.createLeaves(leavesPlaced, worldIn, position.func_177977_b(), boundsIn, rand, false);
                this.createLeaves(leavesPlaced, worldIn, position, boundsIn, rand, false);
                this.createLeaves(leavesPlaced, worldIn, position.func_177984_a(), boundsIn, rand, true);
                this.placeLeafAt(leavesPlaced, worldIn, position.func_177984_a(), boundsIn, rand);
                this.placeLeafAt(leavesPlaced, worldIn, position.func_177981_b(2), boundsIn, rand);
                return true;
            }
            return false;
        }
        return false;
    }

    private void createLeaves(Set<BlockPos> leavesPlaced, IWorldGenerationReader worldIn, BlockPos newPos, MutableBoundingBox boundsIn, Random rand, boolean small) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (small) {
                    if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize || rand.nextInt(3) == 0) continue;
                    this.placeLeafAt(leavesPlaced, worldIn, newPos.func_177982_a(k3, 0, j4), boundsIn, rand);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeafAt(leavesPlaced, worldIn, newPos.func_177982_a(k3, 0, j4), boundsIn, rand);
                    continue;
                }
                if (rand.nextInt(4) != 0) continue;
                this.placeLeafAt(leavesPlaced, worldIn, newPos.func_177982_a(k3, 0, j4), boundsIn, rand);
            }
        }
    }

    private void placeLogAt(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, MutableBoundingBox boundsIn) {
        this.setLogState(changedBlocks, worldIn, pos, ((Block)UABlocks.RIVER_LOG.get()).func_176223_P(), boundsIn);
    }

    private void placeLeafAt(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, MutableBoundingBox boundsIn, Random rand) {
        BlockState state;
        if (FeatureRiverTree.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.setLogState(changedBlocks, (IWorldWriter)world, pos, (BlockState)((Block)UABlocks.RIVER_LEAVES.get()).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)), boundsIn);
        }
        if (FeatureRiverTree.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b()) && rand.nextInt(3) == 0 && rand.nextBoolean() && (state = (BlockState)((BlockState)((Block)UABlocks.MULBERRY_VINE.get()).func_176223_P().func_206870_a((IProperty)BlockMulberryVine.AGE, (Comparable)Integer.valueOf(4))).func_206870_a((IProperty)BlockMulberryVine.DOUBLE, (Comparable)Boolean.valueOf(rand.nextBoolean()))).func_196955_c((IWorldReader)world, pos.func_177977_b())) {
            this.setLogState(changedBlocks, (IWorldWriter)world, pos.func_177977_b(), state, boundsIn);
        }
    }

    protected final void setLogState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState state, MutableBoundingBox boundsIn) {
        worldIn.func_180501_a(pos, state, 18);
        boundsIn.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (BlockTags.field_200031_h.func_199685_a_((Object)state.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    public Consumer<Biome> processBiomeAddition() {
        return biome -> {
            if (biome.func_201856_r() == Biome.Category.RIVER) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UAFeatures.RIVER_TREE.get()).func_225566_b_((IFeatureConfig)RIVER_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.75f, 2))));
            }
        };
    }
}

