/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.blocks;

import com.lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SeatBlock
extends HorizontalBlock
implements IWaterLoggable {
    private static final VoxelShape POST_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    private static final VoxelShape JOIST_SHAPE_NS = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0);
    private static final VoxelShape JOIST_SHAPE_EW = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)7.0, (double)16.0);
    private static final VoxelShape SEAT_SHAPE_NS = VoxelShapes.func_197872_a((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_SHAPE_NS);
    private static final VoxelShape SEAT_SHAPE_EW = VoxelShapes.func_197872_a((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_SHAPE_EW);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    public static final BooleanProperty ATTACHED = BlockStateProperties.field_208174_a;

    public SeatBlock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((IProperty)field_185512_D);
        boolean attached = (Boolean)state.func_177229_b((IProperty)ATTACHED);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                return attached ? SEAT_SHAPE_NS : JOIST_SHAPE_NS;
            }
            case EAST: 
            case WEST: {
                return attached ? SEAT_SHAPE_EW : JOIST_SHAPE_EW;
            }
        }
        return SEAT_SHAPE_NS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(pos);
        IFluidState ifluidstate = world.func_204610_c(pos);
        boolean waterloggedFlag = ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        boolean attachedFlag = this.isInAttachablePos((IWorldReader)world, pos);
        Direction facingDir = context.func_196000_l();
        Direction placementDir = facingDir == Direction.DOWN || facingDir == Direction.UP ? context.func_195992_f().func_176734_d() : facingDir.func_176746_e();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDir)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterloggedFlag))).func_206870_a((IProperty)OCCUPIED, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)ATTACHED, (Comparable)Boolean.valueOf(attachedFlag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a((IProperty)ATTACHED, (Comparable)Boolean.valueOf(this.isInAttachablePos((IWorldReader)worldIn, currentPos)));
        }
        return stateIn;
    }

    private boolean isInAttachablePos(IWorldReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_222432_lU) {
            return true;
        }
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, WATERLOGGED, OCCUPIED, ATTACHED});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean canAttachLantern;
        ItemStack heldItem = player.func_184586_b(handIn);
        BlockState upperBlock = worldIn.func_180495_p(pos.func_177984_a());
        boolean canSit = hit.func_216354_b() == Direction.UP && (Boolean)state.func_177229_b((IProperty)OCCUPIED) == false && heldItem.func_190926_b() && upperBlock.isAir((IBlockReader)worldIn, pos.func_177984_a()) && SeatBlock.isPlayerInRange(player, pos);
        boolean bl = canAttachLantern = hit.func_216354_b() == Direction.DOWN && heldItem.func_77973_b() == Items.field_222111_pQ && worldIn.func_180495_p(pos.func_177977_b()).isAir((IBlockReader)worldIn, pos.func_177977_b());
        if (!worldIn.func_201670_d()) {
            if (canSit) {
                DummyEntityForSitting seat = new DummyEntityForSitting(worldIn, pos);
                worldIn.func_217376_c((Entity)seat);
                player.func_184220_m((Entity)seat);
                return ActionResultType.SUCCESS;
            }
            if (canAttachLantern) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)ATTACHED, (Comparable)Boolean.TRUE));
                worldIn.func_195592_c(pos, (Block)this);
                worldIn.func_175656_a(pos.func_177977_b(), (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_222514_j, (Comparable)Boolean.TRUE));
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    private static boolean isPlayerInRange(PlayerEntity player, BlockPos pos) {
        BlockPos playerPos = player.func_180425_c();
        int blockReachDistance = 2;
        if (blockReachDistance == 0) {
            return playerPos.func_177956_o() - pos.func_177956_o() <= 1 && playerPos.func_177958_n() - pos.func_177958_n() == 0 && playerPos.func_177952_p() - pos.func_177952_p() == 0;
        }
        pos = pos.func_177963_a(0.5, 0.5, 0.5);
        AxisAlignedBB range = new AxisAlignedBB((double)(pos.func_177958_n() + blockReachDistance), (double)(pos.func_177956_o() + blockReachDistance), (double)(pos.func_177952_p() + blockReachDistance), (double)(pos.func_177958_n() - blockReachDistance), (double)(pos.func_177956_o() - blockReachDistance), (double)(pos.func_177952_p() - blockReachDistance));
        return range.field_72340_a <= (double)(playerPos = playerPos.func_177963_a(0.5, 0.5, 0.5)).func_177958_n() && range.field_72338_b <= (double)playerPos.func_177956_o() && range.field_72339_c <= (double)playerPos.func_177952_p() && range.field_72336_d >= (double)playerPos.func_177958_n() && range.field_72337_e >= (double)playerPos.func_177956_o() && range.field_72334_f >= (double)playerPos.func_177952_p();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        List entities = worldIn.func_217357_a(DummyEntityForSitting.class, new AxisAlignedBB(x, y, z, x, y, z));
        for (DummyEntityForSitting entity : entities) {
            entity.func_70106_y();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 20;
    }
}

