/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.ModWoodTypes;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.setup.Registration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;

public class LootTables
extends LootTableProvider {
    private final DataGenerator generator;
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        this.lootTables.put((Block)Registration.BAR_PANEL.get(), this.createSimpleTable("bar_panel", (Block)Registration.BAR_PANEL.get()));
        this.lootTables.put((Block)Registration.CHANDELIER.get(), this.createSimpleTable("chandelier", (Block)Registration.CHANDELIER.get()));
        this.lootTables.put((Block)Registration.CHAIN.get(), this.createSimpleTable("chain", (Block)Registration.CHAIN.get()));
        this.lootTables.put((Block)Registration.BRAZIER.get(), this.createSimpleTable("brazier", (Block)Registration.BRAZIER.get()));
        this.lootTables.put((Block)Registration.STONE_PILLAR.get(), this.createSimpleTable("stone_pillar", (Block)Registration.STONE_PILLAR.get()));
        this.lootTables.put((Block)Registration.ROCKY_DIRT.get(), this.createSimpleTable("rocky_dirt", (Block)Registration.ROCKY_DIRT.get()));
        for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
            for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
                this.lootTables.put(Registration.getWoodDecorativeBlock(wood, type), this.createSimpleTable(wood + "_" + (Object)((Object)type), Registration.getWoodDecorativeBlock(wood, type)));
            }
        }
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    protected LootTable.Builder createSimpleTable(String name, Block block) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block));
        return LootTable.func_216119_b().func_216040_a(builder);
    }
}

