/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.setup;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="decorative_blocks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FogHandler {
    private static Tag<Fluid> fluidTag = null;
    private static boolean fluidTagChecked = false;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        World world = event.getInfo().func_216773_g().func_130014_f_();
        BlockPos pos = event.getInfo().func_216780_d();
        IFluidState state = world.func_204610_c(pos);
        IFluidState actualState = event.getInfo().func_216771_k();
        if (FogHandler.isEntityInHay(state)) {
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
            event.setDensity(2.0f);
            event.setCanceled(true);
        } else {
            if (actualState.func_206884_a(FluidTags.field_206960_b)) {
                event.setCanceled(false);
                return;
            }
            if (actualState.func_206888_e()) {
                event.setDensity(1.0E-5f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        World world = event.getInfo().func_216773_g().func_130014_f_();
        BlockPos pos = event.getInfo().func_216780_d();
        IFluidState state = world.func_204610_c(pos);
        IFluidState actualState = event.getInfo().func_216771_k();
        if (FogHandler.isEntityInHay(state)) {
            event.setRed(0.6745098f);
            event.setGreen(0.5529412f);
            event.setBlue(0.03137255f);
        }
    }

    private static boolean isEntityInHay(IFluidState fluidState) {
        if (fluidTag == null) {
            fluidTag = FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("decorative_blocks", "thatch"));
            fluidTagChecked = true;
        } else if (fluidState.func_206884_a(fluidTag)) {
            return true;
        }
        return false;
    }
}

