/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.setup;

import com.google.common.collect.ImmutableMap;
import com.lilypuree.decorative_blocks.blocks.BarPanelBlock;
import com.lilypuree.decorative_blocks.blocks.BeamBlock;
import com.lilypuree.decorative_blocks.blocks.BonfireBlock;
import com.lilypuree.decorative_blocks.blocks.BrazierBlock;
import com.lilypuree.decorative_blocks.blocks.ChainBlock;
import com.lilypuree.decorative_blocks.blocks.ChandelierBlock;
import com.lilypuree.decorative_blocks.blocks.LatticeBlock;
import com.lilypuree.decorative_blocks.blocks.PalisadeBlock;
import com.lilypuree.decorative_blocks.blocks.PillarBlock;
import com.lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import com.lilypuree.decorative_blocks.blocks.SeatBlock;
import com.lilypuree.decorative_blocks.blocks.SupportBlock;
import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.ModWoodTypes;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import com.lilypuree.decorative_blocks.fluid.ThatchFluid;
import com.lilypuree.decorative_blocks.fluid.ThatchFluidBlock;
import com.lilypuree.decorative_blocks.items.BurnableBlockItem;
import com.lilypuree.decorative_blocks.setup.ModSetup;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class Registration {
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<EntityType<?>> ENTITIES;
    public static final DeferredRegister<Fluid> FLUIDS;
    public static final RegistryObject<BarPanelBlock> BAR_PANEL;
    public static final RegistryObject<LatticeBlock> LATTICE;
    public static final RegistryObject<ChainBlock> CHAIN;
    public static final RegistryObject<ChandelierBlock> CHANDELIER;
    public static final RegistryObject<BrazierBlock> BRAZIER;
    public static final RegistryObject<PillarBlock> STONE_PILLAR;
    public static final RegistryObject<Block> ROCKY_DIRT;
    public static final RegistryObject<BonfireBlock> BONFIRE;
    public static final Item.Properties modItemProperties;
    public static final Item.Properties dummyProperty;
    public static final RegistryObject<Item> BAR_PANEL_ITEM;
    public static final RegistryObject<Item> LATTICE_ITEM;
    public static final RegistryObject<Item> CHAIN_ITEM;
    public static final RegistryObject<Item> CHANDELIER_ITEM;
    public static final RegistryObject<Item> BRAZIER_ITEM;
    public static final RegistryObject<Item> STONE_PILLAR_ITEM;
    public static final RegistryObject<Item> ROCKY_DIRT_ITEM;
    public static final Material THTACH_MATERIAL;
    public static final RegistryObject<FlowingFluid> FLOWING_THATCH;
    public static final RegistryObject<FlowingFluid> STILL_THATCH;
    public static final RegistryObject<Block> THATCH;
    public static final RegistryObject<EntityType<DummyEntityForSitting>> DUMMY_ENTITY_TYPE;
    public static final ImmutableMap<String, RegistryObject<Block>> DECORATIVE_BLOCKS;
    public static final ImmutableMap<String, RegistryObject<Item>> DECORATIVE_ITEMBLOCKS;

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        ENTITIES.register(modEventBus);
        FLUIDS.register(modEventBus);
    }

    public static Block getWoodDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes decorativeBlockType) {
        String name = wood + "_" + (Object)((Object)decorativeBlockType);
        return (Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get();
    }

    public static RotatedPillarBlock getBeamBlock(IWoodType wood) {
        return (RotatedPillarBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.BEAM);
    }

    public static PalisadeBlock getPalisadeBlock(IWoodType wood) {
        return (PalisadeBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.PALISADE);
    }

    public static SeatBlock getSeatBlock(IWoodType wood) {
        return (SeatBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SEAT);
    }

    public static SupportBlock getSupportBlock(IWoodType wood) {
        return (SupportBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SUPPORT);
    }

    private static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        Block.Properties woodProperty = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a);
        Block.Properties palisadeProperty = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 4.0f).func_200947_a(SoundType.field_185848_a);
        switch (woodDecorativeBlockType) {
            default: {
                return new BeamBlock(woodProperty);
            }
            case SEAT: {
                return new SeatBlock(woodProperty);
            }
            case SUPPORT: {
                return new SupportBlock(woodProperty);
            }
            case PALISADE: 
        }
        return new PalisadeBlock(palisadeProperty);
    }

    static {
        String name;
        ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "decorative_blocks");
        BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "decorative_blocks");
        ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "decorative_blocks");
        FLUIDS = new DeferredRegister(ForgeRegistries.FLUIDS, "decorative_blocks");
        BAR_PANEL = BLOCKS.register("bar_panel", () -> new BarPanelBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));
        LATTICE = BLOCKS.register("lattice", () -> new LatticeBlock(Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
        CHAIN = BLOCKS.register("chain", () -> new ChainBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(4.3f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));
        CHANDELIER = BLOCKS.register("chandelier", () -> new ChandelierBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.3f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
        BRAZIER = BLOCKS.register("brazier", () -> new BrazierBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));
        STONE_PILLAR = BLOCKS.register("stone_pillar", () -> new PillarBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 6.5f)));
        ROCKY_DIRT = BLOCKS.register("rocky_dirt", () -> new RockyDirtBlock());
        BONFIRE = BLOCKS.register("bonfire", () -> new BonfireBlock(Block.Properties.func_200949_a((Material)Material.field_151581_o, (MaterialColor)MaterialColor.field_151656_f).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185854_g).func_200951_a(15).func_222380_e()));
        modItemProperties = new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP);
        dummyProperty = new Item.Properties();
        BAR_PANEL_ITEM = ITEMS.register("bar_panel", () -> new BlockItem((Block)BAR_PANEL.get(), modItemProperties));
        LATTICE_ITEM = ITEMS.register("lattice", () -> new BlockItem((Block)LATTICE.get(), modItemProperties));
        CHAIN_ITEM = ITEMS.register("chain", () -> new BlockItem((Block)CHAIN.get(), modItemProperties));
        CHANDELIER_ITEM = ITEMS.register("chandelier", () -> new BurnableBlockItem((Block)CHANDELIER.get(), modItemProperties, 1600));
        BRAZIER_ITEM = ITEMS.register("brazier", () -> new BlockItem((Block)BRAZIER.get(), modItemProperties));
        STONE_PILLAR_ITEM = ITEMS.register("stone_pillar", () -> new BlockItem((Block)STONE_PILLAR.get(), modItemProperties));
        ROCKY_DIRT_ITEM = ITEMS.register("rocky_dirt", () -> new BlockItem((Block)ROCKY_DIRT.get(), modItemProperties));
        THTACH_MATERIAL = new Material.Builder(MaterialColor.field_151673_t).func_200508_c().func_200502_b().func_200509_f().func_200507_a().func_200506_i();
        FLOWING_THATCH = FLUIDS.register("flowing_thatch", ThatchFluid.Flowing::new);
        STILL_THATCH = FLUIDS.register("thatch", ThatchFluid.Source::new);
        THATCH = BLOCKS.register("thatch", () -> new ThatchFluidBlock((Supplier<? extends FlowingFluid>)STILL_THATCH, Block.Properties.func_200945_a((Material)THTACH_MATERIAL).func_200942_a().func_200944_c().func_200943_b(100.0f).func_222380_e()));
        DUMMY_ENTITY_TYPE = ENTITIES.register("dummy", () -> EntityType.Builder.func_220322_a(DummyEntityForSitting::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(256).setUpdateInterval(20).func_220321_a(1.0E-4f, 1.0E-4f).func_206830_a("decorative_blocks:dummy"));
        ImmutableMap.Builder decorativeBlockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
                name = wood + "_" + (Object)((Object)type);
                decorativeBlockBuilder.put((Object)name, (Object)BLOCKS.register(name, () -> Registration.createDecorativeBlock(wood, type)));
            }
        }
        DECORATIVE_BLOCKS = decorativeBlockBuilder.build();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
                name = wood + "_" + (Object)((Object)type);
                itemBuilder.put((Object)name, (Object)ITEMS.register(name, () -> new BurnableBlockItem((Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get(), wood.isAvailable() ? modItemProperties : dummyProperty, 300)));
            }
        }
        DECORATIVE_ITEMBLOCKS = itemBuilder.build();
    }
}

