/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.melanx.extradisks.ExtraDisks;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.BooleanValue retro;
    public static ForgeConfigSpec.BooleanValue moreDisks;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        retro = builder.comment("If set to true, the less op Disk values by Reborn Storage will be used for fluid disks.").define("retro", false);
        moreDisks = builder.comment("If set to true, 4 extra tiers for item storage will be added. Automatically turns retro mode off.").define("higher_disks", false);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        ExtraDisks.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        ConfigHandler.init(SERVER_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

