/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.network.IServerCommand;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.setup.ClientSetup;
import mcjty.lib.setup.DefaultClientProxy;
import mcjty.lib.setup.DefaultServerProxy;
import mcjty.lib.setup.IProxy;
import mcjty.lib.setup.ModSetup;
import mcjty.lib.typed.TypedMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="mcjtylib")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class McJtyLib {
    public static final String MODID = "mcjtylib";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new DefaultClientProxy(), () -> () -> new DefaultServerProxy());
    public static ModSetup setup = new ModSetup();
    public static McJtyLib instance;
    public static SimpleChannel networkHandler;
    public static boolean tesla;
    public static boolean cofhapiitem;
    private static final Map<Pair<String, String>, IServerCommand> serverCommands;
    private static final Map<Pair<String, String>, IServerCommand> clientCommands;

    public McJtyLib() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(setup::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::init));
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, GeneralConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, GeneralConfig.SERVER_CONFIG);
    }

    public static void registerCommand(String modid, String id, IServerCommand command) {
        serverCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static void registerClientCommand(String modid, String id, IServerCommand command) {
        clientCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static boolean handleCommand(String modid, String id, PlayerEntity player, TypedMap arguments) {
        IServerCommand command = serverCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static boolean handleClientCommand(String modid, String id, PlayerEntity player, TypedMap arguments) {
        IServerCommand command = clientCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static LazyOptional<PreferencesProperties> getPreferencesProperties(PlayerEntity player) {
        return player.getCapability(ModSetup.PREFERENCES_CAPABILITY);
    }

    static {
        serverCommands = new HashMap<Pair<String, String>, IServerCommand>();
        clientCommands = new HashMap<Pair<String, String>, IServerCommand>();
    }
}

