/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.debugtools.DumpItemNBT;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.OpList;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class PacketDumpItemInfo {
    private boolean verbose;

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.verbose);
    }

    public PacketDumpItemInfo(ByteBuf buf) {
        this.verbose = buf.readBoolean();
    }

    public PacketDumpItemInfo(boolean verbose) {
        this.verbose = verbose;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ItemStack item;
            int perm;
            ServerPlayerEntity player = ctx.getSender();
            MinecraftServer server = player.func_130014_f_().func_73046_m();
            OpList oppedPlayers = server.func_184103_al().func_152603_m();
            OpEntry entry = (OpEntry)oppedPlayers.func_152683_b((Object)player.func_146103_bH());
            int n = perm = entry == null ? server.func_110455_j() : entry.func_152644_a();
            if (perm >= 1 && !(item = player.func_184614_ca()).func_190926_b()) {
                String output = DumpItemNBT.dumpItemNBT(item, this.verbose);
                Logging.getLogger().log(Level.INFO, "### Server side ###");
                Logging.getLogger().log(Level.INFO, output);
            }
        });
        ctx.setPacketHandled(true);
    }
}

