/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketServerCommandTyped {
    protected BlockPos pos;
    protected DimensionId dimensionId;
    protected String command;
    protected TypedMap params;

    public PacketServerCommandTyped(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
        this.dimensionId = buf.readBoolean() ? DimensionId.fromPacket(buf) : null;
    }

    public PacketServerCommandTyped(BlockPos pos, String command, TypedMap params) {
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dimensionId = null;
    }

    public PacketServerCommandTyped(BlockPos pos, DimensionId dimensionId, String command, TypedMap params) {
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dimensionId = dimensionId;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        TypedMapTools.writeArguments(buf, this.params);
        if (this.dimensionId != null) {
            buf.writeBoolean(true);
            this.dimensionId.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity playerEntity = ctx.getSender();
            Object world = this.dimensionId == null ? playerEntity.func_130014_f_() : WorldTools.getWorld(playerEntity.field_70170_p, this.dimensionId);
            if (world == null) {
                return;
            }
            if (world.func_175667_e(this.pos)) {
                TileEntity te = world.func_175625_s(this.pos);
                if (!(te instanceof ICommandHandler)) {
                    Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                    return;
                }
                ICommandHandler commandHandler = (ICommandHandler)te;
                if (!commandHandler.execute((PlayerEntity)playerEntity, this.command, this.params)) {
                    Logging.log("Command " + this.command + " was not handled!");
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

