/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.IEnergyItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemCapabilityProvider
implements ICapabilityProvider,
IBigPower {
    private final ItemStack itemStack;
    private final IEnergyItem item;
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergyStorage);

    private <T> IEnergyStorage createEnergyStorage() {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return (int)ItemCapabilityProvider.this.item.receiveEnergyL(ItemCapabilityProvider.this.itemStack, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return (int)ItemCapabilityProvider.this.item.extractEnergyL(ItemCapabilityProvider.this.itemStack, maxExtract, simulate);
            }

            public int getEnergyStored() {
                return EnergyTools.getIntEnergyStored(ItemCapabilityProvider.this.item.getEnergyStoredL(ItemCapabilityProvider.this.itemStack), ItemCapabilityProvider.this.item.getMaxEnergyStoredL(ItemCapabilityProvider.this.itemStack));
            }

            public int getMaxEnergyStored() {
                return EnergyTools.unsignedClampToInt(ItemCapabilityProvider.this.item.getMaxEnergyStoredL(ItemCapabilityProvider.this.itemStack));
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }
        };
    }

    public ItemCapabilityProvider(ItemStack itemStack, IEnergyItem item) {
        this.itemStack = itemStack;
        this.item = item;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public long getStoredPower() {
        return this.item.getEnergyStoredL(this.itemStack);
    }

    @Override
    public long getCapacity() {
        return this.item.getMaxEnergyStoredL(this.itemStack);
    }
}

