/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import net.minecraft.block.Block;

public class BlockInformation {
    private static Map<String, BlockInformation> blockInformationMap = new HashMap<String, BlockInformation>();
    private final String blockName;
    private final int blockLevel;
    private final double costFactor;
    private final int rotateInfo;
    public static final int ROTATE_invalid = -1;
    public static final int ROTATE_mmmm = 0;
    public static final int ROTATE_mfff = 1;
    public static final BlockInformation INVALID = new BlockInformation("", 2, 1.0);
    public static final BlockInformation OK = new BlockInformation("", 0, 1.0, 0);
    public static final BlockInformation FREE = new BlockInformation("", 0, 0.0, 0);

    private static int rotateStringToId(String rotateString) {
        if ("mmmm".equals(rotateString)) {
            return 0;
        }
        if ("mfff".equals(rotateString)) {
            return 1;
        }
        return -1;
    }

    public BlockInformation(String blockName, int blockLevel, double costFactor) {
        this.blockName = blockName;
        this.blockLevel = blockLevel;
        this.costFactor = costFactor;
        this.rotateInfo = 0;
    }

    public BlockInformation(String blockName, int blockLevel, double costFactor, int rotateInfo) {
        this.blockName = blockName;
        this.blockLevel = blockLevel;
        this.costFactor = costFactor;
        this.rotateInfo = rotateInfo;
    }

    public BlockInformation(BlockInformation other, String rotateInfo) {
        this(other.blockName, other.blockLevel, other.costFactor, BlockInformation.rotateStringToId(rotateInfo));
    }

    public BlockInformation(BlockInformation other, String blockName, int blockLevel, double costFactor) {
        this(blockName, blockLevel, costFactor, other.rotateInfo);
    }

    static void readBuilderBlocksInternal() {
        try (InputStream inputstream = RFToolsBuilder.class.getResourceAsStream("/data/rftoolsbuilder/text/builder.json");){
            BlockInformation.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.logError((String)"Error reading builder.json", (Throwable)e);
        }
    }

    static void readBuilderBlocksConfig() {
    }

    private static void parseBuilderJson(InputStream inputstream) throws UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            if ("movables".equals(entry.getKey())) {
                BlockInformation.readMovablesFromJson((JsonElement)entry.getValue());
                continue;
            }
            if (!"rotatables".equals(entry.getKey())) continue;
            BlockInformation.readRotatablesFromJson((JsonElement)entry.getValue());
        }
    }

    private static void readMovablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String warningType = entry.getAsJsonArray().get(1).getAsString();
            double costFactor = entry.getAsJsonArray().get(2).getAsDouble();
            int status = "-".equals(warningType) ? 2 : ("+".equals(warningType) ? 0 : 1);
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, blockName, status, costFactor));
        }
    }

    private static void readRotatablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String rotatable = entry.getAsJsonArray().get(1).getAsString();
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, rotatable));
        }
    }

    public static BlockInformation getBlockInformation(Block block) {
        BlockInformation information = blockInformationMap.get(block.getRegistryName().toString());
        if (information == null) {
            String modid = BlockTools.getModidForBlock((Block)block);
            information = blockInformationMap.get("modid:" + modid);
        }
        return information;
    }

    public static void init() {
        BlockInformation.readBuilderBlocksInternal();
        BlockInformation.readBuilderBlocksConfig();
    }

    public int getBlockLevel() {
        return this.blockLevel;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public double getCostFactor() {
        return this.costFactor;
    }

    public int getRotateInfo() {
        return this.rotateInfo;
    }
}

