/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpaceChamberRepository
extends AbstractWorldData<SpaceChamberRepository> {
    private static final String SPACECHAMBER_CHANNELS_NAME = "RFToolsSpaceChambers";
    private int lastId = 0;
    private final Map<Integer, SpaceChamberChannel> channels = new HashMap<Integer, SpaceChamberChannel>();

    public SpaceChamberRepository() {
        super(SPACECHAMBER_CHANNELS_NAME);
    }

    public static SpaceChamberRepository get(World world) {
        return (SpaceChamberRepository)SpaceChamberRepository.getData((World)world, SpaceChamberRepository::new, (String)SPACECHAMBER_CHANNELS_NAME);
    }

    public SpaceChamberChannel getOrCreateChannel(int id) {
        SpaceChamberChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new SpaceChamberChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public SpaceChamberChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        this.channels.clear();
        ListNBT lst = tagCompound.func_150295_c("channels", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            SpaceChamberChannel value = new SpaceChamberChannel();
            value.setDimension(DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tc.func_74779_i("dimension"))));
            value.setMinCorner(BlockPosTools.read((CompoundNBT)tc, (String)"minCorner"));
            value.setMaxCorner(BlockPosTools.read((CompoundNBT)tc, (String)"maxCorner"));
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        ListNBT lst = new ListNBT();
        for (Map.Entry<Integer, SpaceChamberChannel> entry : this.channels.entrySet()) {
            CompoundNBT tc = new CompoundNBT();
            tc.func_74768_a("channel", entry.getKey().intValue());
            tc.func_74778_a("dimension", entry.getValue().getDimension().getRegistryName().toString());
            BlockPosTools.write((CompoundNBT)tc, (String)"minCorner", (BlockPos)entry.getValue().getMinCorner());
            BlockPosTools.write((CompoundNBT)tc, (String)"maxCorner", (BlockPos)entry.getValue().getMaxCorner());
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("channels", (INBT)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static class SpaceChamberChannel {
        private DimensionId dimension;
        private BlockPos minCorner = null;
        private BlockPos maxCorner = null;

        public DimensionId getDimension() {
            return this.dimension;
        }

        public void setDimension(DimensionId dimension) {
            this.dimension = dimension;
        }

        public BlockPos getMinCorner() {
            return this.minCorner;
        }

        public void setMinCorner(BlockPos minCorner) {
            this.minCorner = minCorner;
        }

        public BlockPos getMaxCorner() {
            return this.maxCorner;
        }

        public void setMaxCorner(BlockPos maxCorner) {
            this.maxCorner = maxCorner;
        }
    }
}

