/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.client;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.client.GuiShapeCard;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.builder.network.PacketCloseContainerAndOpenCardGui;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;

public class GuiBuilder
extends GenericGuiContainer<BuilderTileEntity, GenericContainer> {
    private EnergyBar energyBar;
    private Button currentLevel;
    private ImageChoiceLabel[] anchor = new ImageChoiceLabel[4];

    public GuiBuilder(BuilderTileEntity builderTileEntity, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)builderTileEntity, (Container)container, inventory, ((BaseBlock)BuilderModule.BUILDER.get()).getManualEntry());
    }

    public static void register() {
        GuiBuilder.register((ContainerType)((ContainerType)BuilderModule.CONTAINER_BUILDER.get()), GuiBuilder::new);
    }

    public void init() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsBuilderMessages.INSTANCE, new ResourceLocation("rftoolsbuilder", "gui/builder.gui"));
        super.init();
        this.initializeFields();
        this.setupEvents();
    }

    private void setupEvents() {
        this.window.event("cardgui", (source, params) -> this.openCardGui());
        this.window.event("anchor", (source, params) -> this.selectAnchor(source.getName()));
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.currentLevel = (Button)this.window.findChild("level");
        this.anchor[0] = (ImageChoiceLabel)this.window.findChild("anchor0");
        this.anchor[1] = (ImageChoiceLabel)this.window.findChild("anchor1");
        this.anchor[2] = (ImageChoiceLabel)this.window.findChild("anchor2");
        this.anchor[3] = (ImageChoiceLabel)this.window.findChild("anchor3");
        ((ChoiceLabel)this.window.findChild("mode")).choice(BuilderTileEntity.MODES[((BuilderTileEntity)this.tileEntity).getMode()]);
        ChoiceLabel rotateButton = (ChoiceLabel)this.window.findChild("rotate");
        rotateButton.choice(String.valueOf(((BuilderTileEntity)this.tileEntity).getRotate() * 90));
        if (!this.isShapeCard()) {
            this.anchor[((BuilderTileEntity)this.tileEntity).getAnchor()].setCurrentChoice(1);
        }
    }

    private void openCardGui() {
        ItemStack cardStack = ((GenericContainer)this.field_147002_h).func_75139_a(0).func_75211_c();
        if (!cardStack.func_190926_b()) {
            GuiShapeCard.fromTEPos = ((BuilderTileEntity)this.tileEntity).func_174877_v();
            GuiShapeCard.fromTEStackSlot = 0;
            RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketCloseContainerAndOpenCardGui());
        }
    }

    private void selectAnchor(String name) {
        int index = name.charAt(name.length() - 1) - 48;
        this.updateAnchorSettings(index);
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, "builder.setAnchor", TypedMap.builder().put(BuilderTileEntity.PARAM_ANCHOR_INDEX, (Object)index).build());
    }

    private void updateAnchorSettings(int index) {
        for (int i = 0; i < this.anchor.length; ++i) {
            if (this.isShapeCard()) {
                this.anchor[i].setCurrentChoice(0);
                continue;
            }
            this.anchor[i].setCurrentChoice(i == index ? 1 : 0);
        }
    }

    private boolean isShapeCard() {
        ItemStack card = (ItemStack)((BuilderTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h.getStackInSlot(0)).orElse((Object)ItemStack.field_190927_a);
        return !card.func_190926_b() && card.func_77973_b() instanceof ShapeCardItem;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int cury = BuilderTileEntity.getCurrentLevelClientSide();
        this.currentLevel.text("Y: " + (cury == -1 ? "stop" : Integer.valueOf(cury)));
        ItemStack card = (ItemStack)((BuilderTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h.getStackInSlot(0)).orElse((Object)ItemStack.field_190927_a);
        if (card.func_190926_b()) {
            this.window.setFlag("!validcard");
        } else if (card.func_77973_b() instanceof ShapeCardItem) {
            this.window.setFlag("!validcard");
        } else {
            this.window.setFlag("validcard");
        }
        this.updateAnchorSettings(((BuilderTileEntity)this.tileEntity).getAnchor());
        this.drawWindow();
        this.updateEnergyBar(this.energyBar);
    }
}

