/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.modules.builder.client.GuiChamberDetails;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketChamberInfoReady {
    private Map<BlockState, Integer> blocks;
    private Map<BlockState, Integer> costs;
    private Map<BlockState, ItemStack> stacks;
    private Map<String, Integer> entities;
    private Map<String, Integer> entityCosts;
    private Map<String, Entity> realEntities;
    private Map<String, String> playerNames;
    private static final byte ENTITY_NONE = 0;
    private static final byte ENTITY_NORMAL = 1;
    private static final byte ENTITY_PLAYER = 2;

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<BlockState, Integer> entry : this.blocks.entrySet()) {
            BlockState bm = entry.getKey();
            buf.writeInt(Block.func_196246_j((BlockState)bm));
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.costs.get(bm).intValue());
            if (this.stacks.containsKey(bm)) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((PacketBuffer)buf, (ItemStack)this.stacks.get(bm));
                continue;
            }
            buf.writeBoolean(false);
        }
        buf.writeInt(this.entities.size());
        for (Map.Entry<Object, Integer> entry : this.entities.entrySet()) {
            String name = (String)entry.getKey();
            buf.func_180714_a(name);
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.entityCosts.get(name).intValue());
            if (this.realEntities.containsKey(name)) {
                Entity entity = this.realEntities.get(name);
                if (entity instanceof PlayerEntity) {
                    buf.writeByte(2);
                    int entityId = entity.func_145782_y();
                    buf.writeInt(entityId);
                    buf.func_180714_a(entity.func_145748_c_().func_150254_d());
                    continue;
                }
                buf.writeByte(1);
                CompoundNBT nbt = entity.serializeNBT();
                PacketChamberInfoReady.writeNBT(buf, nbt);
                continue;
            }
            buf.writeByte(0);
        }
    }

    private static CompoundNBT readNBT(PacketBuffer buf) {
        return buf.func_150793_b();
    }

    private static void writeNBT(PacketBuffer dataOut, CompoundNBT nbt) {
        PacketBuffer buf = new PacketBuffer((ByteBuf)dataOut);
        try {
            buf.func_150786_a(nbt);
        }
        catch (Exception e) {
            Logging.logError((String)"Error writing packet chamber info", (Throwable)e);
        }
    }

    public PacketChamberInfoReady() {
    }

    public PacketChamberInfoReady(PacketBuffer buf) {
        int cost;
        int count;
        int i;
        int size = buf.readInt();
        this.blocks = new HashMap<BlockState, Integer>(size);
        this.costs = new HashMap<BlockState, Integer>(size);
        this.stacks = new HashMap<BlockState, ItemStack>();
        for (i = 0; i < size; ++i) {
            BlockState bm = Block.func_196257_b((int)buf.readInt());
            count = buf.readInt();
            cost = buf.readInt();
            this.blocks.put(bm, count);
            this.costs.put(bm, cost);
            if (!buf.readBoolean()) continue;
            ItemStack stack = NetworkTools.readItemStack((PacketBuffer)buf);
            this.stacks.put(bm, stack);
        }
        size = buf.readInt();
        this.entities = new HashMap<String, Integer>(size);
        this.entityCosts = new HashMap<String, Integer>(size);
        this.realEntities = new HashMap<String, Entity>();
        this.playerNames = new HashMap<String, String>();
        for (i = 0; i < size; ++i) {
            String className = buf.func_150789_c(Short.MAX_VALUE);
            count = buf.readInt();
            cost = buf.readInt();
            this.entities.put(className, count);
            this.entityCosts.put(className, cost);
            byte how = buf.readByte();
            if (how == 1) {
                CompoundNBT compoundNBT = PacketChamberInfoReady.readNBT(buf);
                continue;
            }
            if (how != 2) continue;
            int entityId = buf.readInt();
            String entityName = buf.func_150789_c(Short.MAX_VALUE);
            Entity entity = McJtyLib.proxy.getClientWorld().func_73045_a(entityId);
            if (entity != null) {
                this.realEntities.put(className, entity);
            }
            this.playerNames.put(className, entityName);
        }
    }

    public PacketChamberInfoReady(Map<BlockState, Integer> blocks, Map<BlockState, Integer> costs, Map<BlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities) {
        this.blocks = new HashMap<BlockState, Integer>(blocks);
        this.costs = new HashMap<BlockState, Integer>(costs);
        this.stacks = new HashMap<BlockState, ItemStack>(stacks);
        this.entities = new HashMap<String, Integer>(entities);
        this.entityCosts = new HashMap<String, Integer>(entityCosts);
        this.realEntities = new HashMap<String, Entity>(realEntities);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> GuiChamberDetails.setItemsWithCount(this.blocks, this.costs, this.stacks, this.entities, this.entityCosts, this.realEntities, this.playerNames));
        ctx.setPacketHandled(true);
    }
}

