/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.AbstractDynamicBakedModel;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import mcjty.rftoolsbuilder.modules.shield.client.ShieldRenderData;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;

public class ShieldBakedModel
extends AbstractDynamicBakedModel {
    public static final ResourceLocation TEXTURE_TRANSPARENT = new ResourceLocation("rftoolsbuilder", "block/shield/shieldtransparent");
    public static final ResourceLocation TEXTURE_FULL = new ResourceLocation("rftoolsbuilder", "block/shield/shieldfull");
    private static Map<ShieldTexture, TextureAtlasSprite[]> shields;
    private static TextureAtlasSprite shieldtransparent;
    private static TextureAtlasSprite shieldfull;

    private static void initTextures() {
        if (shields == null) {
            shields = new HashMap<ShieldTexture, TextureAtlasSprite[]>();
            for (ShieldTexture texture : ShieldTexture.values()) {
                TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield0")), ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield1")), ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield2")), ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield3"))};
                shields.put(texture, sprites);
            }
            shieldtransparent = ShieldBakedModel.getTexture((ResourceLocation)TEXTURE_TRANSPARENT);
            shieldfull = ShieldBakedModel.getTexture((ResourceLocation)TEXTURE_FULL);
        }
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ShieldBakedModel.initTextures();
        ShieldRenderingMode mode = (ShieldRenderingMode)((Object)state.func_177229_b(ShieldingBlock.RENDER_MODE));
        switch (mode) {
            case INVISIBLE: {
                return Collections.emptyList();
            }
            case SHIELD: {
                return this.getQuadsShield(side, extraData);
            }
            case MIMIC: {
                return this.getQuadsMimic(state, side, rand, extraData);
            }
            case TRANSP: {
                return this.getQuadsTextured(side, shieldtransparent, extraData);
            }
            case SOLID: {
                return this.getQuadsTextured(side, shieldfull, extraData);
            }
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> getQuadsShield(@Nullable Direction side, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null) {
            Integer iconTopdown = (Integer)extraData.getData(ShieldingTileEntity.ICON_TOPDOWN);
            Integer iconSide = (Integer)extraData.getData(ShieldingTileEntity.ICON_SIDE);
            ShieldRenderData renderData = (ShieldRenderData)extraData.getData(ShieldingTileEntity.RENDER_DATA);
            if (renderData == null) {
                return quads;
            }
            float r = renderData.getRed();
            float g = renderData.getGreen();
            float b = renderData.getBlue();
            float a = renderData.getAlpha();
            TextureAtlasSprite[] shield = shields.get((Object)renderData.getShieldTexture());
            switch (side) {
                case DOWN: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), shield[iconTopdown], r, g, b, a));
                    break;
                }
                case UP: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), shield[iconTopdown], r, g, b, a));
                    break;
                }
                case NORTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), shield[iconSide], r, g, b, a));
                    break;
                }
                case SOUTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), shield[iconSide], r, g, b, a));
                    break;
                }
                case WEST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), shield[iconSide], r, g, b, a));
                    break;
                }
                case EAST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), shield[iconSide], r, g, b, a));
                }
            }
        }
        return quads;
    }

    private List<BakedQuad> getQuadsTextured(@Nullable Direction side, TextureAtlasSprite texture, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null) {
            ShieldRenderData renderData = (ShieldRenderData)extraData.getData(ShieldingTileEntity.RENDER_DATA);
            if (renderData == null) {
                return quads;
            }
            float r = renderData.getRed();
            float g = renderData.getGreen();
            float b = renderData.getBlue();
            float a = renderData.getAlpha();
            switch (side) {
                case DOWN: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), texture, r, g, b, a));
                    break;
                }
                case UP: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), texture, r, g, b, a));
                    break;
                }
                case NORTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), texture, r, g, b, a));
                    break;
                }
                case SOUTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), texture, r, g, b, a));
                    break;
                }
                case WEST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), texture, r, g, b, a));
                    break;
                }
                case EAST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), texture, r, g, b, a));
                }
            }
        }
        return quads;
    }

    private List<BakedQuad> getQuadsMimic(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, IModelData extraData) {
        BlockState camo = (BlockState)extraData.getData(ShieldingTileEntity.MIMIC);
        if (camo == null) {
            return Collections.emptyList();
        }
        IBakedModel model = this.getModel(camo);
        try {
            return model.getQuads(state, side, rand, null);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private IBakedModel getModel(@Nonnull BlockState facadeState) {
        ShieldBakedModel.initTextures();
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(facadeState);
    }

    public TextureAtlasSprite func_177554_e() {
        ShieldBakedModel.initTextures();
        return shieldfull;
    }
}

