/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tk.zeitheron.solarflux.block.SolarPanelBlock;
import tk.zeitheron.solarflux.block.SolarPanelBlockItem;
import tk.zeitheron.solarflux.block.SolarPanelTile;
import tk.zeitheron.solarflux.container.SolarPanelContainer;
import tk.zeitheron.solarflux.items.ItemsSF;
import tk.zeitheron.solarflux.net.SFNetwork;
import tk.zeitheron.solarflux.panels.SolarPanels;
import tk.zeitheron.solarflux.proxy.SFRClientProxy;
import tk.zeitheron.solarflux.proxy.SFRCommonProxy;

@Mod(value="solarflux")
public class SolarFlux {
    public static final ContainerType<SolarPanelContainer> SOLAR_PANEL_CONTAINER = IForgeContainerType.create((windowId, playerInv, extraData) -> {
        TileEntity tile = playerInv.field_70458_d.field_70170_p.func_175625_s(extraData.func_179259_c());
        if (tile instanceof SolarPanelTile) {
            return new SolarPanelContainer(windowId, playerInv, (SolarPanelTile)tile);
        }
        return null;
    });
    public static final Logger LOG = LogManager.getLogger();
    public static final SFRCommonProxy PROXY = (SFRCommonProxy)DistExecutor.runForDist(() -> () -> new SFRClientProxy(), () -> () -> new SFRCommonProxy());
    public static final ItemGroup ITEM_GROUP = new ItemGroup("solarflux"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_3);
        }
    };

    public SolarFlux() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SolarPanels.init();
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent e) {
        PROXY.commonSetup();
        SFNetwork.init();
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent e) {
        SolarPanels.refreshConfigs();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent e) {
        PROXY.clientSetup();
    }

    @SubscribeEvent
    public void startServer(FMLServerStartingEvent e) {
        e.getCommandDispatcher().register((LiteralArgumentBuilder)Commands.func_197057_a((String)"solarflux").then(Commands.func_197057_a((String)"reload").executes(src -> {
            SolarPanels.refreshConfigs();
            ((CommandSource)src.getSource()).func_197028_i().func_184103_al().func_181057_v().forEach(SFNetwork::sendAllPanels);
            return 1;
        })));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        @SubscribeEvent
        public static void registerTiles(RegistryEvent.Register<TileEntityType<?>> e) {
            e.getRegistry().register(SolarPanels.SOLAR_PANEL_TYPE);
        }

        @SubscribeEvent
        public static void registerContainers(RegistryEvent.Register<ContainerType<?>> e) {
            e.getRegistry().register(SOLAR_PANEL_CONTAINER.setRegistryName("solar_panel"));
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> e) {
            SolarPanels.listPanelBlocks().forEach(arg_0 -> ((IForgeRegistry)e.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> e) {
            ItemsSF.register((IForgeRegistry<Item>)e.getRegistry());
            SolarPanels.listPanelBlocks().forEach(b -> {
                SolarPanelBlockItem item = new SolarPanelBlockItem((SolarPanelBlock)((Object)b), new Item.Properties().func_200916_a(ITEM_GROUP));
                e.getRegistry().register((IForgeRegistryEntry)item);
            });
        }
    }
}

