/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import tk.zeitheron.solarflux.RecipesSF;
import tk.zeitheron.solarflux.block.SolarPanelBlock;
import tk.zeitheron.solarflux.block.SolarPanelTile;
import tk.zeitheron.solarflux.panels.SolarPanelInstance;
import tk.zeitheron.solarflux.panels.SolarPanels;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryCategory;

public class SolarPanel
implements IItemProvider {
    private final SolarPanelData delegateDataBase;
    public final String name;
    public SolarPanelData delegateData;
    public SolarPanelData networkData;
    private String compatMod;
    public List<Supplier<IRecipe<?>>> recipes = new ArrayList();
    public final boolean isCustom;
    private SolarPanelBlock block;
    private LanguageData langs;

    public SolarPanel(String name, SolarPanelData data, boolean isCustom) {
        this.delegateDataBase = this.networkData = data;
        this.delegateData = this.networkData;
        this.name = (isCustom ? "custom_" : "") + name;
        this.isCustom = isCustom;
    }

    public SolarPanelData getPanelData() {
        return this.networkData != null ? this.networkData : this.delegateData;
    }

    public SolarPanel register() {
        if (SolarPanels.PANELS.containsKey(this.name)) {
            throw new IllegalArgumentException("Solar panel with id " + this.name + " already exists.");
        }
        SolarPanels.PANELS.put(this.name, this);
        return this;
    }

    public SolarPanel setCompatMod(String compatMod) {
        this.compatMod = compatMod;
        return this;
    }

    public String getCompatMod() {
        return this.compatMod;
    }

    public void configureBase(ConfigEntryCategory category) {
        this.delegateData = new SolarPanelData(category, this);
    }

    protected SolarPanelBlock createBlock() {
        return new SolarPanelBlock(this);
    }

    public SolarPanelBlock getBlock() {
        if (this.block == null) {
            this.block = this.createBlock();
            this.block.setRegistryName("sp_" + this.name);
        }
        return this.block;
    }

    public Item func_199767_j() {
        return this.getBlock().func_199767_j();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder customBuilder() {
        Builder b = new Builder();
        b.custom = true;
        return b;
    }

    public LanguageData langBuilder() {
        return new LanguageData(this);
    }

    public boolean hasLang() {
        return this.langs != null;
    }

    public LanguageData getLang() {
        return this.langs;
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder(this);
    }

    public float computeSunIntensity(SolarPanelTile solar) {
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.func_145831_w().func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return MathHelper.func_76131_a((float)(multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    public Stream<IRecipe<?>> recipes() {
        return this.recipes == null ? Stream.empty() : this.recipes.stream().map(Supplier::get);
    }

    public SolarPanelInstance createInstance(SolarPanelTile tile) {
        SolarPanelInstance inst = new SolarPanelInstance();
        inst.delegate = this.name;
        inst.infoDelegate = this;
        inst.reset();
        return inst;
    }

    public void accept(SolarPanelInstance t) {
        SolarPanelData data = this.getPanelData();
        t.gen = data.generation;
        t.cap = data.capacity;
        t.transfer = data.transfer;
        t.delegate = this.name;
    }

    public static class SolarPanelData {
        public final long generation;
        public final long capacity;
        public final long transfer;
        public final float height;

        public SolarPanelData(PacketBuffer buf) {
            this.generation = buf.readLong();
            this.capacity = buf.readLong();
            this.transfer = buf.readLong();
            this.height = buf.readFloat();
        }

        public SolarPanelData(long generation, long capacity, long transfer, float height) {
            this.generation = generation;
            this.capacity = capacity;
            this.transfer = transfer;
            this.height = height;
        }

        public SolarPanelData(ConfigEntryCategory cat, SolarPanel base) {
            this.generation = cat.getLongEntry("Generation Rate", ((SolarPanel)base).delegateDataBase.generation, 1L, Long.MAX_VALUE).setDescription("How much FE does this solar panel produce per tick?").getValue();
            this.transfer = cat.getLongEntry("Transfer Rate", ((SolarPanel)base).delegateDataBase.transfer, 1L, Long.MAX_VALUE).setDescription("How much FE does this solar panel emit to other blocks, per tick?").getValue();
            this.capacity = cat.getLongEntry("Capacity", ((SolarPanel)base).delegateDataBase.capacity, 1L, Long.MAX_VALUE).setDescription("How much FE does this solar panel store?").getValue();
            this.height = cat.getFloatEntry("Height", ((SolarPanel)base).delegateDataBase.height * 16.0f, 0.0f, 16.0f).setDescription("How high is this solar panel?").getValue().floatValue() / 16.0f;
        }

        public void write(PacketBuffer buf) {
            buf.writeLong(this.generation);
            buf.writeLong(this.capacity);
            buf.writeLong(this.transfer);
            buf.writeFloat(this.height);
        }
    }

    public static class RecipeBuilder {
        final SolarPanel panel;
        List<Object> args = new ArrayList<Object>();

        public RecipeBuilder(SolarPanel panel) {
            this.panel = panel;
        }

        public RecipeBuilder shape(String ... strings) {
            this.args.addAll(Arrays.asList(strings));
            return this;
        }

        public RecipeBuilder bind(String ch, Object output) {
            if (ch.length() != 1) {
                throw new IllegalArgumentException(ch + " is not a single character!");
            }
            this.args.add(Character.valueOf(ch.charAt(0)));
            this.args.add(output);
            return this;
        }

        public SolarPanel build() {
            return this.build(1);
        }

        public SolarPanel build(int amount) {
            this.panel.recipes.add(() -> RecipesSF.parseShaped(new ItemStack((IItemProvider)this.panel), this.args.toArray(new Object[this.args.size()])));
            return this.panel;
        }
    }

    public static class LanguageData {
        public final Map<String, String> langToName = new HashMap<String, String>();
        public String def;
        final SolarPanel panel;

        public LanguageData(SolarPanel panel) {
            this.panel = panel;
        }

        public LanguageData put(String lang, String loc) {
            if ((lang = lang.toLowerCase()).equals("en_us")) {
                this.def = loc;
            }
            this.langToName.put(lang, loc);
            return this;
        }

        public String getName(String lang) {
            return this.langToName.getOrDefault(lang, this.def);
        }

        public SolarPanel build() {
            if (this.def == null) {
                throw new RuntimeException("Unable to apply languages: no 'en_us' value found!");
            }
            this.panel.langs = this;
            return this.panel;
        }
    }

    public static class Builder {
        String name;
        Long generation;
        Long capacity;
        Long transfer;
        float height = 0.375f;
        boolean custom = false;

        public Builder name(String s) {
            this.name = s;
            return this;
        }

        public Builder height(float f) {
            this.height = f;
            return this;
        }

        public Builder generation(Number n) {
            if (n instanceof Long) {
                this.generation = (Long)n;
                return this;
            }
            return this.generation(Long.toString(n.longValue()));
        }

        public Builder generation(String s) {
            this.generation = new Long(s);
            return this;
        }

        public Builder capacity(Number n) {
            if (n instanceof Long) {
                this.capacity = (Long)n;
                return this;
            }
            return this.capacity(Long.toString(n.longValue()));
        }

        public Builder capacity(String s) {
            this.capacity = new Long(s);
            return this;
        }

        public Builder transfer(Number n) {
            if (n instanceof Long) {
                this.transfer = (Long)n;
                return this;
            }
            return this.transfer(Long.toString(n.longValue()));
        }

        public Builder transfer(String s) {
            this.transfer = new Long(s);
            return this;
        }

        public SolarPanel build() {
            if (this.name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.generation == null) {
                throw new NullPointerException("generation == null");
            }
            if (this.capacity == null) {
                throw new NullPointerException("capacity == null");
            }
            if (this.transfer == null) {
                throw new NullPointerException("transfer == null");
            }
            return new SolarPanel(this.name, new SolarPanelData(this.generation, this.capacity, this.transfer, this.height), this.custom);
        }

        public SolarPanel buildAndRegister() {
            return this.build().register();
        }
    }
}

