/*
 * Decompiled with CFR 0.152.
 */
package mageprotocol.trash.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mageprotocol.trash.container.TrashcanContainer;
import mageprotocol.trash.init.ModObjects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TrashcanTileEntity
extends TileEntity
implements INamedContainerProvider {
    private static final String INVENTORY_TAG = "inventory";
    public final ItemStackHandler inventory = new ItemStackHandler(15){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TrashcanTileEntity.this.func_70296_d();
        }
    };
    private final LazyOptional<ItemStackHandler> inventoryCapabilityExternal = LazyOptional.of(() -> this.inventory);

    public TrashcanTileEntity() {
        super((TileEntityType)ModObjects.TRASHCAN_TILEENTITY.get());
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l(INVENTORY_TAG));
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a(INVENTORY_TAG, (INBT)this.inventory.serializeNBT());
        return nbt;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModObjects.TRASHCAN.get()).func_149739_a(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new TrashcanContainer(windowID, playerInventory, this);
    }

    public void voidItems(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TrashcanTileEntity) {
            int slots = ((TrashcanTileEntity)tileEntity).inventory.getSlots();
            for (int i = 0; i < slots; ++i) {
                ((TrashcanTileEntity)tileEntity).inventory.setStackInSlot(i, new ItemStack((IItemProvider)Items.field_190931_a));
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapabilityExternal.cast();
        }
        return super.getCapability(cap, side);
    }
}

