/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.client.render;

import com.farcr.savageandravage.client.model.CreepieModel;
import com.farcr.savageandravage.common.entity.CreepieEntity;
import com.farcr.savageandravage.core.registry.other.SRConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class CreepieRenderer
extends MobRenderer<CreepieEntity, CreepieModel> {
    private static final ResourceLocation CREEPIE_TEXTURES = new ResourceLocation("textures/entity/creeper/creeper.png");

    public CreepieRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new CreepieModel(), 0.3f);
    }

    protected void preRenderCallback(CreepieEntity entityLivingBaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float creeperFlashIntensity = entityLivingBaseIn.getCreeperFlashIntensity(partialTickTime);
        float mathsThing = 1.0f + MathHelper.func_76126_a((float)(creeperFlashIntensity * 100.0f)) * creeperFlashIntensity * 0.01f;
        creeperFlashIntensity = MathHelper.func_76131_a((float)creeperFlashIntensity, (float)0.0f, (float)1.0f);
        creeperFlashIntensity *= creeperFlashIntensity;
        creeperFlashIntensity *= creeperFlashIntensity;
        float multipliedByMathsThing = (1.0f + creeperFlashIntensity * 0.4f) * mathsThing;
        float dividedByMathsThing = (1.0f + creeperFlashIntensity * 0.1f) / mathsThing;
        matrixStackIn.func_227862_a_(multipliedByMathsThing, dividedByMathsThing, multipliedByMathsThing);
        matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        if (SRConfig.CreepieGoBigWhenBoom) {
            float creeperFlashIntensity2 = entityLivingBaseIn.getCreeperFlashIntensity(partialTickTime);
            float mathsThing2 = 1.0f + MathHelper.func_76126_a((float)(creeperFlashIntensity2 * 100.0f)) * creeperFlashIntensity2 * 0.01f;
            creeperFlashIntensity2 = MathHelper.func_76131_a((float)creeperFlashIntensity2, (float)0.0f, (float)1.0f);
            creeperFlashIntensity2 *= creeperFlashIntensity2;
            creeperFlashIntensity2 *= creeperFlashIntensity2;
            float multipliedByMathsThing2 = (1.0f + creeperFlashIntensity + 0.4f) * mathsThing2;
            float dividedByMathsThing2 = (1.0f + creeperFlashIntensity + 0.4f) / mathsThing2;
            matrixStackIn.func_227862_a_(multipliedByMathsThing2, dividedByMathsThing2, multipliedByMathsThing2);
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
    }

    protected float getOverlayProgress(CreepieEntity livingEntityIn, float partialTicks) {
        float flashIntensity = livingEntityIn.getCreeperFlashIntensity(partialTicks);
        return (int)(flashIntensity * 10.0f) % 2 == 0 ? 0.0f : MathHelper.func_76131_a((float)flashIntensity, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getEntityTexture(CreepieEntity entity) {
        return CREEPIE_TEXTURES;
    }

    protected void applyRotations(CreepieEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entityLiving.isConverting()) {
            rotationYaw += (float)(Math.cos((double)entityLiving.field_70173_aa * 3.25) * Math.PI * 0.25);
        }
        super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }
}

