/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.common.entity;

import com.farcr.savageandravage.common.entity.IOwnableMob;
import com.farcr.savageandravage.common.entity.goals.ConditionalNearestAttackableTargetGoal;
import com.farcr.savageandravage.common.entity.goals.CreepieSwellGoal;
import com.farcr.savageandravage.common.entity.goals.FollowMobOwnerGoal;
import com.farcr.savageandravage.common.entity.goals.MobOwnerHurtByTargetGoal;
import com.farcr.savageandravage.common.entity.goals.MobOwnerHurtTargetGoal;
import com.farcr.savageandravage.core.registry.SRParticles;
import com.farcr.savageandravage.core.registry.SRSounds;
import com.teamabnormals.abnormals_core.core.library.api.IAgeableEntity;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class CreepieEntity
extends MonsterEntity
implements IOwnableMob,
IAgeableEntity {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> CONVERTING = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int lastActiveTime;
    public int timeSinceIgnited;
    public int fuseTime = 30;
    private float explosionRadius = 1.2f;
    private int growingAge = -24000;
    private int forcedAge;
    private int forcedAgeTimer;
    private int conversionTime;

    public CreepieEntity(EntityType<? extends CreepieEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 2;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CreepieSwellGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, OcelotEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, CatEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowMobOwnerGoal((MobEntity)this, 1.0, 2.0f, 20.0f, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new MobOwnerHurtByTargetGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new MobOwnerHurtTargetGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new ConditionalNearestAttackableTargetGoal((MobEntity)this, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    protected boolean func_225511_J_() {
        return this.getOwner() == null;
    }

    public boolean func_191990_c(PlayerEntity playerIn) {
        return this.getOwner() == null;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        boolean flag = super.func_225503_b_(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return flag;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.growingAge = -24000;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(CONVERTING, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
        compound.func_74768_a("Age", this.getGrowingAge());
        compound.func_74768_a("ForcedAge", this.forcedAge);
        compound.func_74768_a("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_196167_cx);
    }

    public void func_70037_a(CompoundNBT compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable var4) {
                this.setOwnerId(null);
            }
        }
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
        this.setGrowingAge(compound.func_74762_e("Age"));
        this.forcedAge = compound.func_74762_e("ForcedAge");
        if (compound.func_150297_b("ConversionTime", 99) && compound.func_74762_e("ConversionTime") > -1) {
            this.startConverting(compound.func_74762_e("ConversionTime"));
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    public int getGrowingAge() {
        if (this.field_70170_p.field_72995_K) {
            return this.growingAge < 0 ? -1 : 1;
        }
        return this.growingAge;
    }

    private void ageUp(int growthSeconds, boolean updateForcedAge) {
        int i = this.getGrowingAge();
        if ((i += growthSeconds * 20) > 0) {
            i = 0;
        }
        int j = 0;
        this.setGrowingAge(i);
        if (updateForcedAge) {
            this.forcedAge += j;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    public void setGrowingAge(int age) {
        int i = this.growingAge;
        this.growingAge = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.onGrowingIntoCreeper();
        }
    }

    protected void explode() {
        if (!this.field_70170_p.field_72995_K) {
            Explosion.Mode explosion$mode = Explosion.Mode.NONE;
            float chargedModifier = 1.0f;
            this.field_70729_aU = true;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.explosionRadius * chargedModifier, explosion$mode);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.func_70089_S()) {
            int i = this.getGrowingAge();
            if (i < 0) {
                this.setGrowingAge(++i);
            } else if (i > 0) {
                this.setGrowingAge(--i);
            }
        }
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SRSounds.CREEPIE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SRSounds.CREEPIE_DEATH.get();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a((SoundEvent)SRSounds.CREEPIE_PRIMED.get(), this.func_70599_aP(), this.func_70647_i());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
            if (this.isConverting()) {
                if (!this.field_70170_p.field_72995_K) {
                    --this.conversionTime;
                    if (this.conversionTime <= 0) {
                        this.finishConversion((ServerWorld)this.field_70170_p);
                    }
                }
                this.field_70170_p.func_195594_a((IParticleData)SRParticles.CREEPER_SPORES.get(), this.func_226277_ct_() - 0.5 + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.5, this.func_226281_cx_() - 0.5 + (double)this.field_70146_Z.nextFloat(), 0.0, (double)(this.field_70146_Z.nextFloat() / 5.0f), 0.0);
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_196106_bc && this.isNotCreeper()) {
            this.consumeItemFromStack(player, itemstack);
            player.func_226292_a_(hand, true);
            this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f), true);
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_222118_a(1, (LivingEntity)player, p_213625_1_ -> p_213625_1_.func_213334_d(hand));
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    protected void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(1.0f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    private void consumeItemFromStack(PlayerEntity player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    private void onGrowingIntoCreeper() {
        if (!this.field_70170_p.field_72995_K) {
            this.startConverting(this.field_70146_Z.nextInt(80) + 160);
        }
    }

    private boolean isNotCreeper() {
        return this.getGrowingAge() < 0;
    }

    public boolean func_70631_g_() {
        return true;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getOwnerId() != null;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.ofNullable(ownerId));
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        if (!this.field_70170_p.field_72995_K) {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : (LivingEntity)((ServerWorld)this.field_70170_p).func_217461_a(uuid);
        }
        return null;
    }

    public boolean func_213336_c(LivingEntity target) {
        return !this.isOwner(target) && super.func_213336_c(target);
    }

    private boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        if (target instanceof CreepieEntity) {
            CreepieEntity creepieEntity = (CreepieEntity)target;
            return creepieEntity.getOwner() != owner;
        }
        return !(target instanceof PlayerEntity) || !(owner instanceof PlayerEntity) || ((PlayerEntity)owner).func_96122_a((PlayerEntity)target);
    }

    public boolean isConverting() {
        return (Boolean)this.func_184212_Q().func_187225_a(CONVERTING);
    }

    private void startConverting(int conversionTimeIn) {
        this.conversionTime = conversionTimeIn;
        this.func_184212_Q().func_187227_b(CONVERTING, (Object)true);
        if (this.func_70613_aW()) {
            this.func_184185_a((SoundEvent)SRSounds.CREEPIE_BEGIN_CONVERSION.get(), 1.0f, 1.0f);
        }
    }

    private void finishConversion(ServerWorld world) {
        CreeperEntity creeperEntity = (CreeperEntity)EntityType.field_200797_k.func_200721_a(this.field_70170_p);
        creeperEntity.func_82149_j(this.getEntity());
        creeperEntity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)creeperEntity)), SpawnReason.CONVERSION, null, null);
        this.field_70729_aU = true;
        this.func_70106_y();
        creeperEntity.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            creeperEntity.func_200203_b(this.func_200201_e());
            creeperEntity.func_174805_g(this.func_174833_aM());
        }
        if (this.func_104002_bU()) {
            creeperEntity.func_110163_bv();
        }
        if (this.func_110167_bD()) {
            creeperEntity.func_110162_b(this.func_110166_bE(), true);
            this.func_110160_i(true, false);
        }
        if (this.func_184187_bx() != null) {
            creeperEntity.func_184220_m(this.func_184187_bx());
        }
        creeperEntity.func_184224_h(this.func_190530_aW());
        creeperEntity.func_70606_j(creeperEntity.func_110138_aP());
        this.field_70170_p.func_217376_c((Entity)creeperEntity);
        if (this.func_70613_aW()) {
            this.func_184185_a((SoundEvent)SRSounds.CREEPIE_GROW.get(), 1.0f, 1.0f);
        }
    }

    public Team func_96124_cp() {
        LivingEntity livingentity;
        if (this.getOwnerId() != null && (livingentity = this.getOwner()) != null) {
            return livingentity.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.getOwnerId() != null) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

