/*
 * Decompiled with CFR 0.152.
 */
package net.evilcult.scenic;

import net.evilcult.scenic.client.ScenicColours;
import net.evilcult.scenic.client.ScenicRenderTypes;
import net.evilcult.scenic.registry.ScenicBlocks;
import net.evilcult.scenic.registry.ScenicFeatures;
import net.evilcult.scenic.registry.ScenicItems;
import net.evilcult.scenic.world.gen.ScenicBiomeFeatures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="scenic")
public class Scenic {
    public static Scenic INSTANCE;
    public static final String MODID = "scenic";
    public static IEventBus MOD_EVENT_BUS;
    public static final Logger LOGGER;

    public Scenic() {
        INSTANCE = this;
        MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_EVENT_BUS.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MOD_EVENT_BUS.addListener(EventPriority.LOWEST, this::clientSetup));
        ScenicItems.ITEMS.register(MOD_EVENT_BUS);
        ScenicBlocks.BLOCKS.register(MOD_EVENT_BUS);
        ScenicFeatures.FEATURES.register(MOD_EVENT_BUS);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ScenicBiomeFeatures.addBiomeFeatures();
            ScenicBlocks.registerFlammables();
            ScenicItems.registerCompostables();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ScenicColours.registerColours();
            ScenicRenderTypes.setRenderTypes();
        });
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

