/*
 * Decompiled with CFR 0.152.
 */
package net.evilcult.scenic.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class FlatBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final Vec3d OFFSET = new Vec3d(0.0, -0.46875, 0.0);

    public FlatBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos position, @Nonnull PathType type) {
        return type == PathType.AIR && !this.field_196274_w || super.func_196266_a(state, world, position, type);
    }

    protected boolean isValidGround(BlockState state, IBlockReader world, BlockPos position) {
        return !state.func_196952_d(world, position).func_212434_a(Direction.UP).func_197766_b();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos position) {
        BlockPos blockPos = position.func_177977_b();
        return this.isValidGround(world.func_180495_p(blockPos), (IBlockReader)world, blockPos);
    }

    public boolean func_200123_i(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos position) {
        return true;
    }

    @Nonnull
    public Vec3d func_190949_e(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos position) {
        return OFFSET;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean isWaterLogged = fluidState.func_206884_a(FluidTags.field_206959_a) && fluidState.func_206882_g() == 8;
        return (BlockState)Objects.requireNonNull(super.func_196258_a(context)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
    }

    @Nonnull
    public IFluidState func_204507_t(@Nonnull BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState facingState, IWorld world, BlockPos position, BlockPos facing) {
        if (!state.func_196955_c((IWorldReader)world, position)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(position, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, direction, facingState, world, position, facing);
    }
}

