/*
 * Decompiled with CFR 0.152.
 */
package net.evilcult.scenic.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class RockPileBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty ROCKS = IntegerProperty.func_177719_a((String)"rocks", (int)1, (int)7);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape ONE_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    protected static final VoxelShape TWO_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    protected static final VoxelShape THREE_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    protected static final VoxelShape FOUR_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    protected static final VoxelShape FIVE_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    protected static final VoxelShape SIX_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    protected static final VoxelShape SEVEN_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

    public RockPileBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)ROCKS, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos position, @Nonnull ISelectionContext context) {
        switch ((Integer)state.func_177229_b((IProperty)ROCKS)) {
            default: {
                return ONE_SHAPE;
            }
            case 2: {
                return TWO_SHAPE;
            }
            case 3: {
                return THREE_SHAPE;
            }
            case 4: {
                return FOUR_SHAPE;
            }
            case 5: {
                return FIVE_SHAPE;
            }
            case 6: {
                return SIX_SHAPE;
            }
            case 7: 
        }
        return SEVEN_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockState.func_177230_c() == this) {
            return (BlockState)blockState.func_206870_a((IProperty)ROCKS, (Comparable)Integer.valueOf(Math.min(7, (Integer)blockState.func_177229_b((IProperty)ROCKS) + 1)));
        }
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean isWaterLogged = fluidState.func_206884_a(FluidTags.field_206959_a) && fluidState.func_206882_g() == 8;
        return (BlockState)Objects.requireNonNull(super.func_196258_a(context)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
    }

    protected boolean isValidGround(BlockState state, IBlockReader world, BlockPos position) {
        return !state.func_196952_d(world, position).func_212434_a(Direction.UP).func_197766_b();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos position) {
        BlockPos blockPos = position.func_177977_b();
        return this.isValidGround(world.func_180495_p(blockPos), (IBlockReader)world, blockPos);
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState facingState, IWorld world, BlockPos position, BlockPos facing) {
        if (!state.func_196955_c((IWorldReader)world, position)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(position, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, direction, facingState, world, position, facing);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        return context.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((IProperty)ROCKS) < 7 || super.func_196253_a(state, context);
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.func_206894_a(new IProperty[]{ROCKS, WATERLOGGED});
    }

    public boolean func_200123_i(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos position) {
        return true;
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos position, @Nonnull PathType type) {
        return type == PathType.AIR && !this.field_196274_w || super.func_196266_a(state, world, position, type);
    }
}

