/*
 * Decompiled with CFR 0.152.
 */
package net.evilcult.scenic.world.gen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import net.evilcult.scenic.registry.ScenicBlocks;
import net.evilcult.scenic.registry.ScenicFeatures;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class ScenicBiomeFeatures {
    private static final BlockState DIRT = Blocks.field_150346_d.func_176223_P();
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState COBBLESTONE = Blocks.field_150347_e.func_176223_P();
    private static final BlockState MOSSY_COBBLESTONE = Blocks.field_150341_Y.func_176223_P();
    private static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private static final BlockState GRASS_BLOCK = Blocks.field_196658_i.func_176223_P();
    private static final BlockState GRASS_SHORT = ((Block)ScenicBlocks.GRASS_SHORT.get()).func_176223_P();
    private static final BlockState GRASS_TUFT = ((Block)ScenicBlocks.GRASS_TUFT.get()).func_176223_P();
    private static final BlockState ROOTS = ((Block)ScenicBlocks.ROOTS.get()).func_176223_P();
    private static final BlockState ROOTS_LONG = ((Block)ScenicBlocks.ROOTS_LONG.get()).func_176223_P();
    private static final BlockState ROOTS_GROUND = ((Block)ScenicBlocks.ROOTS_GROUND.get()).func_176223_P();
    private static final BlockState ROCKY_DIRT = ((Block)ScenicBlocks.ROCKY_DIRT.get()).func_176223_P();
    private static final BlockState MOSSY_ROCKY_DIRT = ((Block)ScenicBlocks.MOSSY_ROCKY_DIRT.get()).func_176223_P();
    private static final BlockState MOSSY_GRAVEL = ((Block)ScenicBlocks.MOSSY_GRAVEL.get()).func_176223_P();
    private static final BlockState TREASURE_POT = ((Block)ScenicBlocks.TREASURE_POT.get()).func_176223_P();
    private static final BlockState ROCK_PILE = ((Block)ScenicBlocks.ROCK_PILE.get()).func_176223_P();
    private static final BlockState STALAGMITE = ((Block)ScenicBlocks.STALAGMITE.get()).func_176223_P();
    private static final BlockState STALACTITE = ((Block)ScenicBlocks.STALACTITE.get()).func_176223_P();
    private static final BlockState FISH_BONES = ((Block)ScenicBlocks.FISH_BONES.get()).func_176223_P();
    public static final BlockClusterFeatureConfig GRASS_SHORT_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GRASS_SHORT), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig GRASS_TUFT_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GRASS_TUFT), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig ROOTS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ROOTS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig ROOTS_LONG_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ROOTS_LONG), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig ROOTS_GROUND_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ROOTS_GROUND), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(8).func_227322_d_();
    public static final BlockClusterFeatureConfig FISH_BONES_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(FISH_BONES), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(4).func_227322_d_();
    public static final CountConfig ROCK_PILE_CONFIG = new CountConfig(20);
    public static final BlockClusterFeatureConfig STALAGMITE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(STALAGMITE), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227318_b_(20).func_227323_d_(20).func_227316_a_((Set)ImmutableSet.of((Object)STONE.func_177230_c())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig STALACTITE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(STALACTITE), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227318_b_(20).func_227323_d_(20).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig TREASURE_POT_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(TREASURE_POT), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(256).func_227316_a_((Set)ImmutableSet.of((Object)COBBLESTONE.func_177230_c(), (Object)MOSSY_COBBLESTONE.func_177230_c())).func_227317_b_().func_227322_d_();

    public static void addBiomeFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ROCKY_DIRT, 20)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 128))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)ScenicFeatures.ROCK_PILE_FEATURE.get()).func_225566_b_((IFeatureConfig)ROCK_PILE_CONFIG).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 60))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)STALAGMITE_CONFIG).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 60))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)STALACTITE_CONFIG).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 60))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TREASURE_POT_CONFIG).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 60))));
            if (biome.func_201856_r() == Biome.Category.RIVER || biome.func_201856_r() == Biome.Category.SWAMP) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(MOSSY_GRAVEL, 4, 2, (List)Lists.newArrayList((Object[])new BlockState[]{GRASS_BLOCK, DIRT, GRAVEL}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(MOSSY_ROCKY_DIRT, 3, 1, (List)Lists.newArrayList((Object[])new BlockState[]{GRASS_BLOCK, DIRT}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
            }
            if (biome.func_201856_r() == Biome.Category.BEACH) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)FISH_BONES_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
            }
            if (biome.func_201856_r() != Biome.Category.PLAINS && biome.func_201856_r() != Biome.Category.FOREST && biome.func_201856_r() != Biome.Category.EXTREME_HILLS && biome.func_201856_r() != Biome.Category.TAIGA && biome.func_201856_r() != Biome.Category.SAVANNA && biome.func_201856_r() != Biome.Category.JUNGLE) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GRASS_SHORT_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GRASS_TUFT_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)ROOTS_CONFIG).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(12, 0, 0, 64))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)ROOTS_LONG_CONFIG).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(15, 0, 0, 64))));
            if (biome.func_201856_r() != Biome.Category.FOREST && biome.func_201856_r() != Biome.Category.TAIGA) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)ROOTS_GROUND_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        }
    }
}

