/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import top.theillusivec4.comforts.common.tileentity.ComfortsBaseTileEntity;

public abstract class ComfortsBaseTileEntityRenderer<T extends ComfortsBaseTileEntity>
extends TileEntityRenderer<T> {
    private final String type;
    protected ModelRenderer headPiece = new ModelRenderer(0, 0, 0, 0);
    protected ModelRenderer footPiece = new ModelRenderer(0, 0, 0, 0);

    public ComfortsBaseTileEntityRenderer(TileEntityRendererDispatcher dispatcher, String type) {
        super(dispatcher);
        this.type = type;
    }

    public void render(ComfortsBaseTileEntity tileEntityIn, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Material material = new Material(PlayerContainer.field_226615_c_, new ResourceLocation("comforts", "entity/" + this.type + "/" + tileEntityIn.getColor().func_176610_l()));
        World world = tileEntityIn.func_145831_w();
        if (world != null) {
            BlockState blockstate = tileEntityIn.func_195044_w();
            TileEntityMerger.ICallbackWrapper icallbackwrapper = TileEntityMerger.func_226924_a_((TileEntityType)TileEntityType.field_200994_y, BedBlock::func_226863_i_, BedBlock::func_226862_h_, (DirectionProperty)ChestBlock.field_176459_a, (BlockState)blockstate, (IWorld)world, (BlockPos)tileEntityIn.func_174877_v(), (p_228846_0_, p_228846_1_) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).get(combinedLightIn);
            this.renderPiece(matrixStackIn, bufferIn, blockstate.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.HEAD, (Direction)blockstate.func_177229_b((IProperty)BedBlock.field_185512_D), material, i, combinedOverlayIn, false);
        } else {
            this.renderPiece(matrixStackIn, bufferIn, true, Direction.SOUTH, material, combinedLightIn, combinedOverlayIn, false);
            this.renderPiece(matrixStackIn, bufferIn, false, Direction.SOUTH, material, combinedLightIn, combinedOverlayIn, true);
        }
    }

    protected void renderPiece(MatrixStack matrixStack, IRenderTypeBuffer buffer, boolean isHead, Direction direction, Material material, int light, int overlay, boolean p_228847_8_) {
        this.headPiece.field_78806_j = isHead;
        this.footPiece.field_78806_j = !isHead;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.1875, p_228847_8_ ? -1.0 : 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f + direction.func_185119_l()));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder ivertexbuilder = material.func_229311_a_(buffer, RenderType::func_228634_a_);
        this.headPiece.func_228308_a_(matrixStack, ivertexbuilder, light, overlay);
        this.footPiece.func_228308_a_(matrixStack, ivertexbuilder, light, overlay);
        matrixStack.func_227865_b_();
    }
}

