/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.attributefix;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigurationHandler {
    private static final IAttribute[] ATTRIBUTES = new IAttribute[]{SharedMonsterAttributes.field_111267_a, SharedMonsterAttributes.field_111265_b, SharedMonsterAttributes.field_111266_c, SharedMonsterAttributes.field_111263_d, SharedMonsterAttributes.field_193334_e, SharedMonsterAttributes.field_111264_e, SharedMonsterAttributes.field_188790_f, SharedMonsterAttributes.field_188791_g, SharedMonsterAttributes.field_189429_h, SharedMonsterAttributes.field_188792_h};
    private final Map<RangedAttribute, AttributeData> attributeValues = new HashMap<RangedAttribute, AttributeData>();
    private final ForgeConfigSpec spec;

    public ConfigurationHandler() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (IAttribute attribute : ATTRIBUTES) {
            if (!(attribute instanceof RangedAttribute)) continue;
            RangedAttribute rangedAttribute = (RangedAttribute)attribute;
            this.attributeValues.put(rangedAttribute, new AttributeData(rangedAttribute, builder));
        }
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public void applyChanges() {
        for (IAttribute attribute : ATTRIBUTES) {
            if (!(attribute instanceof RangedAttribute)) continue;
            RangedAttribute rangedAttribute = (RangedAttribute)attribute;
            AttributeData data = this.attributeValues.get(rangedAttribute);
            rangedAttribute.field_111118_b = (Double)data.max.get();
        }
    }

    private class AttributeData {
        private final ForgeConfigSpec.DoubleValue max;

        public AttributeData(RangedAttribute attribute, ForgeConfigSpec.Builder builder) {
            String group = attribute.func_111108_a().replace("generic.", "").replace(".", "").toLowerCase();
            builder.comment("Values for the " + group + " attribute.");
            builder.push(group);
            this.max = builder.defineInRange("max", Math.max(-65536.0, 65536.0), Double.MIN_VALUE, Double.MAX_VALUE);
            builder.pop();
        }
    }
}

