/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.reload;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import shadows.menu.PackMenu;
import shadows.menu.buttons.JsonButton;

public class ButtonManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonButton.class, (json, type, ctx) -> JsonButton.deserialize(json.getAsJsonObject())).setPrettyPrinting().create();
    protected Map<ResourceLocation, JsonButton> buttons = new TreeMap<ResourceLocation, JsonButton>();

    public ButtonManager() {
        super(GSON, "buttons");
    }

    protected void apply(Map<ResourceLocation, JsonObject> objects, IResourceManager mgr, IProfiler profiler) {
        this.buttons.clear();
        for (Map.Entry<ResourceLocation, JsonObject> obj : objects.entrySet()) {
            try {
                JsonButton btn = (JsonButton)((Object)GSON.fromJson((JsonElement)obj.getValue(), JsonButton.class));
                this.buttons.put(obj.getKey(), btn);
            }
            catch (Exception e) {
                PackMenu.LOGGER.error("Failed to load button {}.", (Object)obj.getKey());
                e.printStackTrace();
            }
        }
        PackMenu.LOGGER.info("Loaded {} buttons from resources.", (Object)this.buttons.size());
    }

    public Collection<JsonButton> getButtons() {
        return this.buttons.values();
    }
}

