/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.api.fish;

import com.teammetallurgy.aquaculture.Aquaculture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.Item;

public class FishData {
    private final ConcurrentHashMap<Item, Double> WEIGHT_MIN = new ConcurrentHashMap();
    private final ConcurrentHashMap<Item, Double> WEIGHT_MAX = new ConcurrentHashMap();
    private final ConcurrentHashMap<Item, Integer> FILLET_AMOUNT = new ConcurrentHashMap();

    public void addWeight(Item fish, double min, double max) {
        if (!this.WEIGHT_MAX.containsKey(fish)) {
            this.WEIGHT_MIN.put(fish, min);
            this.WEIGHT_MAX.put(fish, max);
        } else {
            Aquaculture.LOG.error(fish.getRegistryName() + " already have a fish weight assigned to it");
        }
    }

    public double getMinWeight(Item fish) {
        return this.WEIGHT_MIN.get(fish);
    }

    public double getMaxWeight(Item fish) {
        return this.WEIGHT_MAX.get(fish);
    }

    public boolean hasWeight(Item fish) {
        return this.WEIGHT_MIN.containsKey(fish) || this.WEIGHT_MAX.containsKey(fish);
    }

    public List<Item> getFish() {
        return new ArrayList<Item>(this.WEIGHT_MIN.keySet());
    }

    public void add(Item fish, double min, double max) {
        this.add(fish, min, max, 1);
    }

    public void add(Item fish, double min, double max, int filletAmount) {
        this.addWeight(fish, min, max);
        if (filletAmount > 0) {
            this.addFilletAmount(fish, filletAmount);
        }
    }

    public void addFilletAmount(Item fish, int filletAmount) {
        if (!this.FILLET_AMOUNT.containsKey(fish)) {
            this.FILLET_AMOUNT.put(fish, filletAmount);
        } else {
            Aquaculture.LOG.error(fish.getRegistryName() + " already have a fish fillet amount assigned to it");
        }
    }

    public boolean hasFilletAmount(Item fish) {
        return this.FILLET_AMOUNT.containsKey(fish);
    }

    public int getFilletAmount(Item fish) {
        return this.FILLET_AMOUNT.get(fish);
    }
}

