/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.misc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDictionaryHelper {
    public static final BiomeDictionary.Type TWILIGHT = BiomeDictionary.Type.getType((String)"TWILIGHT", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);

    public static BiomeDictionary.Type getType(String name) {
        Map byName = BiomeDictionary.Type.getAll().stream().collect(Collectors.toMap(BiomeDictionary.Type::getName, Function.identity()));
        name = name.toUpperCase();
        return (BiomeDictionary.Type)byName.get(name);
    }

    public static BiomeDictionary.Type[] toBiomeTypeArray(List<? extends String> strings) {
        BiomeDictionary.Type[] types = new BiomeDictionary.Type[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            types[i] = BiomeDictionaryHelper.getType(string);
        }
        return types;
    }

    public static void addSpawn(EntityType entityType, int min, int max, int weight, List<? extends String> include, List<? extends String> exclude) {
        if (weight > 0) {
            ArrayList spawnableBiomes = Lists.newArrayList();
            List<BiomeDictionary.Type> includeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray(include));
            List<BiomeDictionary.Type> excludeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray(exclude));
            if (!includeList.isEmpty()) {
                for (BiomeDictionary.Type type : includeList) {
                    for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                        if (biome.func_76747_a(entityType.func_220339_d()).isEmpty()) continue;
                        spawnableBiomes.add(biome);
                    }
                }
                if (!excludeList.isEmpty()) {
                    for (BiomeDictionary.Type type : excludeList) {
                        if (type == null) continue;
                        Set excludeBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
                        for (Biome biome : excludeBiomes) {
                            spawnableBiomes.remove(biome);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Do not leave the BiomeDictionary type inclusion list empty. If you wish to disable spawning of an entity, set the weight to 0 instead.");
            }
            for (Biome biome : spawnableBiomes) {
                biome.func_76747_a(entityType.func_220339_d()).add(new Biome.SpawnListEntry(entityType, weight, min, max));
            }
        }
    }
}

