/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import epicsquid.mysticallib.MysticalLib;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ItemUtil {
    private static Field hoverStart = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"field_70290_d");
    private static boolean accessible;

    public static boolean equalWithoutSize(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77984_f() == stack2.func_77984_f() && stack1.func_77952_i() == stack2.func_77952_i() && ItemUtil.equalWithoutDamage(stack1, stack2);
    }

    public static boolean equalWithoutDamage(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemEntity spawnItem(World world, BlockPos pos, ItemStack stack) {
        return ItemUtil.spawnItem(world, pos, stack, -1);
    }

    public static ItemEntity spawnItem(World world, BlockPos pos, ItemStack stack, float hoverStart) {
        return ItemUtil.spawnItem(world, pos, stack, true, -1, hoverStart);
    }

    public static ItemEntity spawnItem(World world, BlockPos pos, ItemStack stack, int ticks) {
        return ItemUtil.spawnItem(world, pos, stack, true, ticks, -1.0f);
    }

    public static ItemEntity spawnItem(World world, BlockPos pos, ItemStack stack, boolean offset) {
        return ItemUtil.spawnItem(world, pos, stack, offset, -1, -1.0f);
    }

    public static ItemEntity spawnItem(World world, BlockPos pos, ItemStack stack, boolean offset, int ticks, float hoverStart) {
        return ItemUtil.spawnItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), offset, stack, ticks, hoverStart);
    }

    public static void setHoverStart(ItemEntity item, float value) {
        if (accessible) {
            try {
                hoverStart.set(item, Float.valueOf(value));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static ItemEntity spawnItem(World world, double x, double y, double z, boolean offset, ItemStack stack, int ticks, float hoverStart) {
        if (offset) {
            x += 0.5;
            y += 0.5;
            z += 0.5;
        }
        ItemEntity item = new ItemEntity(world, x, y, z, stack);
        if (ticks != -1) {
            item.func_174867_a(ticks);
        }
        if (hoverStart != -1.0f) {
            ItemUtil.setHoverStart(item, hoverStart);
        }
        return ItemUtil.spawnItem(world, item);
    }

    public static ItemEntity spawnItem(World world, ItemEntity item) {
        item.func_213293_j(0.0, 0.0, 0.0);
        world.func_217376_c((Entity)item);
        return item;
    }

    static {
        try {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(hoverStart, hoverStart.getModifiers() & 0xFFFFFFEF);
            accessible = true;
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            MysticalLib.LOG.error("Unable to make 'hoverStart' accessible.");
            accessible = false;
        }
    }
}

