/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class ListUtil {
    public static StateComparator stateComparator = new StateComparator();
    public static StackComparator stackComparator = new StackComparator();

    public static boolean stateListsMatch(List<BlockState> list1, List<BlockState> list2) {
        boolean doMatch;
        list1.sort(stateComparator);
        list2.sort(stateComparator);
        boolean bl = doMatch = list1.size() == list2.size();
        if (doMatch) {
            for (int i = 0; i < list1.size(); ++i) {
                if (list1.get(i).func_177230_c() == list2.get(i).func_177230_c() && list1.get(i).getBlockState().toString() == list2.get(i).getBlockState().toString()) continue;
                doMatch = false;
            }
        }
        return doMatch;
    }

    public static boolean stackListsMatch(List<ItemStack> list1, List<ItemStack> list2) {
        boolean doMatch;
        list1.sort(stackComparator);
        list2.sort(stackComparator);
        boolean bl = doMatch = list1.size() == list2.size();
        if (doMatch) {
            for (int i = 0; i < list1.size(); ++i) {
                if (list1.get(i).func_77973_b() == list2.get(i).func_77973_b()) continue;
                doMatch = false;
            }
        }
        return doMatch;
    }

    public static boolean matchesIngredients(List<ItemStack> ingredients, List<Ingredient> selfIngredients) {
        List actualInput = ingredients.stream().filter(i -> i != null && !i.func_190926_b()).sorted(stackComparator).collect(Collectors.toList());
        List actualIngredients = selfIngredients.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (actualInput.size() != actualIngredients.size()) {
            return false;
        }
        IntOpenHashSet foundIngredients = new IntOpenHashSet();
        IntOpenHashSet usedItemStacks = new IntOpenHashSet();
        block0: for (int i2 = 0; i2 < actualIngredients.size(); ++i2) {
            Ingredient ingredient = (Ingredient)actualIngredients.get(i2);
            for (int j = 0; j < actualInput.size(); ++j) {
                if (usedItemStacks.contains(j) || !ingredient.test((ItemStack)actualInput.get(j))) continue;
                usedItemStacks.add(j);
                foundIngredients.add(i2);
                continue block0;
            }
        }
        return foundIngredients.size() == actualIngredients.size();
    }

    public static class StackComparator
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack arg0, ItemStack arg1) {
            return arg0.func_77973_b().getRegistryName().toString().compareTo(arg1.func_77973_b().getRegistryName().toString());
        }
    }

    public static class StateComparator
    implements Comparator<BlockState> {
        @Override
        public int compare(BlockState arg0, BlockState arg1) {
            return (arg0.func_177230_c().getRegistryName().toString() + "_" + arg0.getBlockState().toString()).compareTo(arg1.func_177230_c().getRegistryName().toString() + "_" + arg1.getBlockState().toString());
        }
    }
}

