/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static Random rand = new Random();

    @Nonnull
    public static <T extends TileEntity> List<T> getTileEntitiesWithin(@Nonnull World world, @Nonnull Class<? extends T> teClass, BlockPos pos, int radius) {
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        for (int i = pos.func_177958_n() - radius; i <= pos.func_177958_n() + radius; ++i) {
            for (int j = pos.func_177956_o() - radius; j <= pos.func_177956_o() + radius; ++j) {
                for (int k = pos.func_177952_p() - radius; k <= pos.func_177952_p() + radius; ++k) {
                    TileEntity t;
                    BlockPos p = new BlockPos(i, j, k);
                    IChunk c = world.func_217349_x(p);
                    if (!c.func_201593_f() || !teClass.isInstance(t = world.func_217349_x(p).func_175625_s(p))) continue;
                    tiles.add(t);
                }
            }
        }
        return tiles;
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(World world, Class<? extends T> classEntity, BlockPos pos, float xradius, float yradius, float zradius) {
        return world.func_217357_a(classEntity, new AxisAlignedBB((double)((float)pos.func_177958_n() - xradius), (double)((float)pos.func_177956_o() - yradius), (double)((float)pos.func_177952_p() - zradius), (double)((float)pos.func_177958_n() + xradius), (double)((float)pos.func_177956_o() + yradius), (double)((float)pos.func_177952_p() + zradius)));
    }

    public static List<LivingEntity> getEntitiesWithinRadius(World world, Predicate<Entity> comparison, BlockPos pos, float xradius, float yradius, float zradius) {
        return world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)((float)pos.func_177958_n() - xradius), (double)((float)pos.func_177956_o() - yradius), (double)((float)pos.func_177952_p() - zradius), (double)((float)pos.func_177958_n() + xradius), (double)((float)pos.func_177956_o() + yradius), (double)((float)pos.func_177952_p() + zradius))).stream().filter(comparison).collect(Collectors.toList());
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Block ... block) {
        List<Block> blocks = Arrays.asList(block);
        return Util.getBlocksWithinRadius(world, pos, xradius, yradius, zradius, (BlockPos test) -> blocks.contains(world.func_180495_p(test).func_177230_c()));
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Block block) {
        return Util.getBlocksWithinRadius(world, pos, xradius, yradius, zradius, (BlockPos test) -> world.func_180495_p(test).func_177230_c() == block);
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Predicate<BlockPos> comparison) {
        ArrayList<BlockPos> blockList = new ArrayList<BlockPos>();
        int x = (int)(-xradius);
        while ((float)x <= xradius) {
            int z = (int)(-zradius);
            while ((float)z <= zradius) {
                int y = (int)(-yradius);
                while ((float)y <= yradius) {
                    if (comparison.test(pos.func_177982_a(x, y, z))) {
                        blockList.add(pos.func_177982_a(x, y, z));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return blockList;
    }

    @Nonnull
    public static String lowercase(@Nonnull String s) {
        String f = "";
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if (c.toUpperCase().compareTo(c) == 0) {
                if (i > 0) {
                    f = f + "_";
                }
                f = f + c.toLowerCase();
                continue;
            }
            f = f + c;
        }
        return f;
    }

    public static String englishName(ResourceLocation location) {
        String internalName = location.func_110623_a();
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static int intColor(int r, int g, int b) {
        return -16777216 + r * 65536 + g * 256 + b;
    }

    @Nonnull
    public static String getLowercaseClassName(@Nonnull Class c) {
        String[] nameParts = c.getTypeName().split("\\.");
        String className = nameParts[nameParts.length - 1];
        return Util.lowercase(className);
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).func_190926_b()) continue;
                world.func_217376_c((Entity)new ItemEntity(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }

    public static void appendLoreTag(ItemStack stack, String ... lines) {
        ListNBT lore;
        CompoundNBT display;
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        if (tag.func_74781_a("display") == null || !(tag.func_74781_a("display") instanceof CompoundNBT)) {
            display = new CompoundNBT();
            tag.func_218657_a("display", (INBT)display);
        } else {
            display = tag.func_74775_l("display");
        }
        if (tag.func_74781_a("lore") == null || !(display.func_74781_a("lore") instanceof ListNBT)) {
            lore = new ListNBT();
            display.func_218657_a("lore", (INBT)lore);
        } else {
            lore = display.func_150295_c("lore", 8);
        }
        for (String string : lines) {
            lore.add((Object)StringNBT.func_229705_a_((String)string));
        }
    }

    public static ItemStack damageItem(int amount, ItemStack stack, CraftingInventory inventory) {
        WorkbenchContainer wb;
        PlayerEntity player;
        Container container = (Container)ObfuscationReflectionHelper.getPrivateValue(CraftingInventory.class, (Object)inventory, (String)"field_70465_c");
        if (container instanceof WorkbenchContainer && (player = (PlayerEntity)ObfuscationReflectionHelper.getPrivateValue(WorkbenchContainer.class, (Object)(wb = (WorkbenchContainer)container), (String)"field_192390_i")) != null) {
            stack.func_222118_a(amount, (LivingEntity)player, p -> {});
            return stack;
        }
        if (stack.func_96631_a(amount, rand, null)) {
            stack.func_190918_g(1);
        }
        return stack;
    }
}

