/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.world;

import epicsquid.mysticallib.world.GenerationNode;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class GenerationData
extends WorldSavedData {
    private Set<GenerationNode> nodes = new HashSet<GenerationNode>();

    public GenerationData(@Nonnull String name) {
        super(name);
    }

    public GenerationData() {
        this("mysticallib_generation_data");
    }

    public void addNode(@Nonnull GenerationNode node) {
        this.nodes.add(node);
        this.func_76185_a();
    }

    public void func_76184_a(@Nonnull CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("gen_data_nodes", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.nodes.add(new GenerationNode(list.func_150305_b(i)));
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (GenerationNode g : this.nodes) {
            list.add((Object)g.write());
        }
        compound.func_218657_a("gen_data_nodes", (INBT)list);
        return compound;
    }

    public void update(@Nonnull World world) {
        HashSet<GenerationNode> toDelete = new HashSet<GenerationNode>();
        for (GenerationNode n : this.nodes) {
            if (n != null) {
                n.update(world);
            }
            if (n != null && n.isAlive) continue;
            toDelete.add(n);
        }
        for (GenerationNode n : toDelete) {
            this.nodes.remove(n);
        }
        toDelete.clear();
    }
}

