/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import shadows.apotheosis.spawn.SpawnerModifiers;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;

public class ModifierTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("apotheosis", "spawner_modifier");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners == null) {
            ModifierTrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, ModifierTrigger$listeners);
        }
        ModifierTrigger$listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.remove(listener);
            if (ModifierTrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        MinMaxBounds.IntBound minDelay = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("min_delay"));
        MinMaxBounds.IntBound maxDelay = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("max_delay"));
        MinMaxBounds.IntBound spawnCount = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("spawn_count"));
        MinMaxBounds.IntBound nearbyEnts = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("max_nearby_entities"));
        MinMaxBounds.IntBound playerRange = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("player_activation_range"));
        MinMaxBounds.IntBound spawnRange = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("spawn_range"));
        Boolean ignorePlayers = json.has("ignore_players") ? Boolean.valueOf(json.get("ignore_players").getAsBoolean()) : null;
        Boolean ignoreConditions = json.has("ignore_conditions") ? Boolean.valueOf(json.get("ignore_conditions").getAsBoolean()) : null;
        Boolean ignoreCap = json.has("ignore_cap") ? Boolean.valueOf(json.get("ignore_cap").getAsBoolean()) : null;
        Boolean redstone = json.has("redstone") ? Boolean.valueOf(json.get("redstone").getAsBoolean()) : null;
        JsonElement modif = json.get("modifier");
        SpawnerModifier modifier = null;
        if (modif != null) {
            modifier = SpawnerModifiers.MODIFIERS.stream().filter(m -> m.getCategory().equals(modif.getAsString())).findAny().orElse(null);
        }
        return new Instance(minDelay, maxDelay, spawnCount, nearbyEnts, playerRange, spawnRange, ignorePlayers, ignoreConditions, ignoreCap, redstone, modifier);
    }

    public void trigger(ServerPlayerEntity player, ApothSpawnerTile tile, SpawnerModifier modif) {
        Listeners ModifierTrigger$listeners = this.listeners.get(player.func_192039_O());
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.trigger(tile, modif);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ApothSpawnerTile tile, SpawnerModifier modif) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(tile, modif)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final MinMaxBounds.IntBound minDelay;
        private final MinMaxBounds.IntBound maxDelay;
        private final MinMaxBounds.IntBound spawnCount;
        private final MinMaxBounds.IntBound nearbyEnts;
        private final MinMaxBounds.IntBound playerRange;
        private final MinMaxBounds.IntBound spawnRange;
        private final Boolean ignorePlayers;
        private final Boolean ignoreConditions;
        private final Boolean ignoreCap;
        private final Boolean redstone;
        private final SpawnerModifier modifier;

        public Instance(MinMaxBounds.IntBound minDelay, MinMaxBounds.IntBound maxDelay, MinMaxBounds.IntBound spawnCount, MinMaxBounds.IntBound nearbyEnts, MinMaxBounds.IntBound playerRange, MinMaxBounds.IntBound spawnRange, Boolean ignorePlayers, Boolean ignoreConditions, Boolean ignoreCap, Boolean redstone, SpawnerModifier modifier) {
            super(ID);
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.spawnCount = spawnCount;
            this.nearbyEnts = nearbyEnts;
            this.playerRange = playerRange;
            this.spawnRange = spawnRange;
            this.ignorePlayers = ignorePlayers;
            this.ignoreConditions = ignoreConditions;
            this.ignoreCap = ignoreCap;
            this.redstone = redstone;
            this.modifier = modifier;
        }

        public JsonElement func_200288_b() {
            return new JsonObject();
        }

        public boolean test(ApothSpawnerTile tile, SpawnerModifier modif) {
            ApothSpawnerTile.SpawnerLogicExt logic = (ApothSpawnerTile.SpawnerLogicExt)tile.field_145882_a;
            if (this.modifier != null && modif != this.modifier) {
                return false;
            }
            if (!this.minDelay.func_211339_d(logic.field_98283_g)) {
                return false;
            }
            if (!this.maxDelay.func_211339_d(logic.field_98293_h)) {
                return false;
            }
            if (!this.spawnCount.func_211339_d(logic.field_98294_i)) {
                return false;
            }
            if (!this.nearbyEnts.func_211339_d(logic.field_98292_k)) {
                return false;
            }
            if (!this.playerRange.func_211339_d(logic.field_98289_l)) {
                return false;
            }
            if (!this.spawnRange.func_211339_d(logic.field_98290_m)) {
                return false;
            }
            if (this.ignorePlayers != null && tile.ignoresPlayers != this.ignorePlayers) {
                return false;
            }
            if (this.ignoreConditions != null && tile.ignoresConditions != this.ignoreConditions) {
                return false;
            }
            if (this.ignoreCap != null && tile.ignoresCap != this.ignoreCap) {
                return false;
            }
            return this.redstone == null || tile.redstoneEnabled == this.redstone;
        }
    }
}

