/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.DeadlyFeature;
import shadows.apotheosis.deadly.gen.WeightedGenerator;
import shadows.apotheosis.deadly.loot.BossArmorManager;
import shadows.apotheosis.deadly.loot.LootManager;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.util.AttributeHelper;

public class BossItem
extends WeightedGenerator.WorldFeatureItem {
    public static final List<Effect> POTIONS = new ArrayList<Effect>();
    public static final Predicate<Goal> IS_VILLAGER_ATTACK = a -> a instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoal)a).field_75307_b == VillagerEntity.class;
    protected final EntityType<?> entityEntry;
    protected AxisAlignedBB entityAABB;

    public BossItem(int weight, ResourceLocation entity) {
        super(weight);
        this.entityEntry = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
        Preconditions.checkNotNull(this.entityEntry, (Object)("Invalid BossItem (not an entity) created with reloc: " + entity));
    }

    public AxisAlignedBB getAABB(IWorld world) {
        if (this.entityAABB == null) {
            this.entityAABB = this.entityEntry.func_200721_a(world.func_201672_e()).func_70046_E();
        }
        if (this.entityAABB == null) {
            this.entityAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return this.entityAABB;
    }

    @Override
    public void place(IWorld world, BlockPos pos) {
        this.place(world, pos, world.func_201674_k());
    }

    public void place(IWorld world, BlockPos pos, Random rand) {
        MobEntity entity = (MobEntity)this.entityEntry.func_200721_a(world.func_201672_e());
        BossItem.initBoss(rand, entity);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c((Entity)entity);
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, -2, 2))) {
            world.func_180501_a(p, DeadlyConfig.bossFillerBlock.func_176223_P(), 2);
        }
        DeadlyFeature.debugLog(pos, "Boss " + entity.func_200200_C_().func_150261_e());
    }

    public static void initBoss(Random random, MobEntity entity) {
        int res;
        int duration = entity instanceof CreeperEntity ? 6000 : Integer.MAX_VALUE;
        int regen = DeadlyConfig.bossRegenLevel.generateInt(random) - 1;
        if (regen >= 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, duration, regen));
        }
        if ((res = DeadlyConfig.bossResistLevel.generateInt(random) - 1) >= 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76429_m, duration, res));
        }
        if (random.nextFloat() < DeadlyConfig.bossFireRes) {
            entity.func_195064_c(new EffectInstance(Effects.field_76426_n, duration));
        }
        if (random.nextFloat() < DeadlyConfig.bossWaterBreathing) {
            entity.func_195064_c(new EffectInstance(Effects.field_76427_o, duration));
        }
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111264_e, (String)"boss_damage_bonus", (double)(DeadlyConfig.bossDamageMult.func_186507_b(random) - 1.0f));
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111267_a, (String)"boss_health_mult", (double)(DeadlyConfig.bossHealthMultiplier.func_186507_b(random) - 1.0f));
        AttributeHelper.addToBase((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111266_c, (String)"boss_knockback_resist", (double)DeadlyConfig.bossKnockbackResist.func_186507_b(random));
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111263_d, (String)"boss_speed_mult", (double)(DeadlyConfig.bossSpeedMultiplier.func_186507_b(random) - 1.0f));
        entity.func_70606_j(entity.func_110138_aP());
        entity.field_70714_bg.field_220892_d.removeIf(IS_VILLAGER_ATTACK);
        entity.func_110163_bv();
        String name = NameHelper.setEntityName(random, entity);
        BossArmorManager.INSTANCE.getRandomSet(random).apply((LivingEntity)entity);
        if (entity instanceof SkeletonEntity) {
            entity.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151031_f));
        }
        int guaranteed = random.nextInt(6);
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.values()[guaranteed]);
        while (guaranteed == 1 || stack.func_190926_b()) {
            guaranteed = random.nextInt(6);
            stack = entity.func_184582_a(EquipmentSlotType.values()[guaranteed]);
        }
        for (EquipmentSlotType s : EquipmentSlotType.values()) {
            if (s.ordinal() == guaranteed) {
                entity.func_184642_a(s, 2.0f);
            } else {
                entity.func_184642_a(s, ThreadLocalRandom.current().nextFloat() / 2.0f);
            }
            if (s.ordinal() == guaranteed) {
                entity.func_184201_a(s, BossItem.modifyBossItem(stack, random, name));
                continue;
            }
            if (!(random.nextDouble() < (double)DeadlyConfig.bossEnchantChance)) continue;
            List ench = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)(30 + random.nextInt(Apotheosis.enableEnch ? 20 : 10)), (boolean)true);
            EnchantmentHelper.func_82782_a((Map)ench.stream().collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c, (v1, v2) -> Math.max(v1, v2), HashMap::new)), (ItemStack)stack);
        }
        if (POTIONS.isEmpty()) {
            BossItem.initPotions();
        }
        if (random.nextDouble() < (double)DeadlyConfig.bossPotionChance) {
            entity.func_195064_c(new EffectInstance(POTIONS.get(random.nextInt(POTIONS.size())), duration, random.nextInt(3) + 1));
        }
    }

    public static void initPotions() {
        for (Effect p2 : ForgeRegistries.POTIONS) {
            if (!p2.func_188408_i() || p2.func_76403_b()) continue;
            POTIONS.add(p2);
        }
        POTIONS.removeIf(p -> DeadlyConfig.BLACKLISTED_POTIONS.contains(p.getRegistryName()));
    }

    public static ItemStack modifyBossItem(ItemStack stack, Random random, String bossName) {
        List ench = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)(Apotheosis.enableEnch ? 60 : 30), (boolean)true);
        EnchantmentHelper.func_82782_a(ench.stream().collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c, (a, b) -> Math.max(a, b))), (ItemStack)stack);
        String itemName = NameHelper.setItemName(random, stack, bossName);
        stack.func_200302_a((ITextComponent)new StringTextComponent(itemName));
        LootRarity rarity = LootRarity.random(random, 475);
        stack = LootManager.genLootItem(stack, random, rarity);
        stack.func_200302_a(new TranslationTextComponent("%s %s", new Object[]{TextFormatting.RESET + rarity.getColor().toString() + String.format(NameHelper.ownershipFormat, bossName), stack.func_200301_q()}).func_211708_a(rarity.getColor()));
        HashMap enchMap = new HashMap();
        for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            if (e.getKey() == null) continue;
            enchMap.put(e.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)e.getKey()), (Integer)e.getValue() + random.nextInt(2)));
        }
        EnchantmentHelper.func_82782_a(enchMap, (ItemStack)stack);
        stack.func_77978_p().func_74757_a("apoth_boss", true);
        return stack;
    }
}

