/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import shadows.apotheosis.deadly.DeadlyLoot;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.config.DeadlyConstants;
import shadows.apotheosis.deadly.gen.DeadlyFeature;
import shadows.apotheosis.deadly.gen.SpawnerItem;
import shadows.apotheosis.deadly.gen.WeightedGenerator;
import shadows.apotheosis.util.TagBuilder;
import shadows.placebo.util.ChestBuilder;

public class BrutalSpawnerGenerator
extends WeightedGenerator {
    public static final CompoundNBT BASE_TAG = new CompoundNBT();
    public static final List<SpawnerItem> BRUTAL_SPAWNERS = new ArrayList<SpawnerItem>();

    @Override
    public boolean generate(IWorld world, int chunkX, int chunkZ, Random rand) {
        int y;
        if ((double)DeadlyConfig.brutalSpawnerChance <= rand.nextDouble()) {
            return false;
        }
        int x = (chunkX << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        int z = (chunkZ << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos.Mutable mPos = new BlockPos.Mutable(x, y, z);
        for (y = 15 + rand.nextInt(35); y > 10; --y) {
            if (!this.canBePlaced(world, (BlockPos)mPos.func_181079_c(x, y, z), rand)) continue;
            this.place(world, (BlockPos)mPos.func_181079_c(x, y, z), rand);
            DeadlyFeature.setSuccess(world.func_201675_m().func_186058_p().getRegistryName(), chunkX, chunkZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBePlaced(IWorld world, BlockPos pos, Random rand) {
        BlockState state = world.func_180495_p(pos);
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        return DeadlyFeature.STONE_TEST.test(downState) && upState.isAir((IBlockReader)world, pos.func_177984_a()) && (state.isAir((IBlockReader)world, pos) || DeadlyFeature.STONE_TEST.test(state));
    }

    @Override
    public void place(IWorld world, BlockPos pos, Random rand) {
        ((SpawnerItem)WeightedRandom.func_76271_a((Random)rand, BRUTAL_SPAWNERS)).place(world, pos);
        ChestBuilder.place((IWorld)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(rand.nextInt(9) == 0 ? DeadlyLoot.CHEST_VALUABLE : DeadlyLoot.SPAWNER_BRUTAL));
        world.func_180501_a(pos.func_177984_a(), Blocks.field_196700_dk.func_176223_P(), 2);
        for (Direction f : Direction.Plane.HORIZONTAL) {
            if (!world.func_180495_p(pos.func_177972_a(f)).isAir((IBlockReader)world, pos.func_177972_a(f))) continue;
            BooleanProperty side = (BooleanProperty)Blocks.field_150395_bd.func_176194_O().func_185920_a(f.func_176734_d().func_176610_l());
            world.func_180501_a(pos.func_177972_a(f), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)side, (Comparable)Boolean.valueOf(true)), 2);
        }
        DeadlyFeature.debugLog(pos, "Brutal Spawner");
    }

    @Override
    public boolean isEnabled() {
        return !BRUTAL_SPAWNERS.isEmpty() && DeadlyConfig.brutalSpawnerChance > 0.0f;
    }

    public static void init() {
        for (EffectInstance p : DeadlyConfig.BRUTAL_POTIONS) {
            TagBuilder.addPotionEffect(BASE_TAG, p.func_188419_a(), p.func_76458_c());
        }
        SpawnerItem.addItems(BRUTAL_SPAWNERS, DeadlyConstants.BRUTAL_SPAWNER_STATS, DeadlyConfig.BRUTAL_MOBS);
        for (SpawnerItem i : BRUTAL_SPAWNERS) {
            BrutalSpawnerGenerator.initBrutal(i);
        }
    }

    public static void initBrutal(SpawnerItem item) {
        BrutalSpawnerGenerator.applyBrutalStats(item.getSpawner().getSpawnData());
        for (INBT tag : item.getSpawner().getPotentials()) {
            BrutalSpawnerGenerator.applyBrutalStats(BrutalSpawnerGenerator.getOrCreate((CompoundNBT)tag, "Entity"));
        }
    }

    public static CompoundNBT applyBrutalStats(CompoundNBT tag) {
        TagBuilder.checkForSkeleton(tag);
        for (String name : BASE_TAG.func_150296_c()) {
            tag.func_218657_a(name, BASE_TAG.func_74781_a(name).func_74737_b());
        }
        return TagBuilder.checkForCreeper(tag);
    }

    private static CompoundNBT getOrCreate(CompoundNBT parent, String key) {
        if (!parent.func_150297_b(key, 10)) {
            parent.func_218657_a(key, (INBT)new CompoundNBT());
        }
        return parent.func_74775_l(key);
    }
}

