/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.coremod.api.ASMAPI;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.util.GearSet;
import shadows.apotheosis.util.json.ItemAdapter;
import shadows.apotheosis.util.json.NBTAdapter;

public class BossArmorManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(CompoundNBT.class, (Object)NBTAdapter.INSTANCE).setFieldNamingStrategy(f -> f.getName().equals(ASMAPI.mapField((String)"field_76292_a")) ? "weight" : f.getName()).create();
    public static final BossArmorManager INSTANCE = new BossArmorManager();
    protected final Map<ResourceLocation, GearSet> registry = new HashMap<ResourceLocation, GearSet>();
    protected final List<GearSet> sets = new ArrayList<GearSet>();

    public BossArmorManager() {
        super(GSON, "boss_gear");
    }

    protected void apply(Map<ResourceLocation, JsonObject> objects, IResourceManager mgr, IProfiler profiler) {
        this.sets.clear();
        this.registry.clear();
        objects.forEach((id, obj) -> {
            try {
                this.register((ResourceLocation)id, (GearSet)((Object)((Object)GSON.fromJson((JsonElement)obj, GearSet.class))));
            }
            catch (Exception e) {
                DeadlyModule.LOGGER.error("Failed to load boss armor set {}.", (Object)id.toString());
                e.printStackTrace();
            }
        });
        if (this.registry.isEmpty()) {
            throw new RuntimeException("No Apotheosis Boss armor sets were registered.  At least one is required.");
        }
        DeadlyModule.LOGGER.info("Registered {} boss gear sets.", (Object)this.sets.size());
    }

    public void register(ResourceLocation id, GearSet set) {
        if (!this.registry.containsKey(id)) {
            this.registry.put(id, set);
            this.sets.add(set);
        } else {
            DeadlyModule.LOGGER.error("Attempted to register an ArmorSet with name {}, but it already exists!", (Object)id);
        }
    }

    public GearSet getRandomSet(Random random) {
        return (GearSet)WeightedRandom.func_76271_a((Random)random, this.sets);
    }
}

