/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.deadly.loot.EquipmentType;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.deadly.loot.affix.Affix;

public class AffixHelper {
    public static final String AFFIXES = "Affixes";

    public static void applyAffix(ItemStack stack, Affix affix, float level) {
        CompoundNBT tag = stack.func_190925_c(AFFIXES);
        tag.func_74776_a(affix.getRegistryName().toString(), level);
    }

    public static Map<Affix, Float> getAffixes(ItemStack stack) {
        HashMap<Affix, Float> map = new HashMap<Affix, Float>();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(AFFIXES)) {
            CompoundNBT tag = stack.func_77978_p().func_74775_l(AFFIXES);
            for (String key : tag.func_150296_c()) {
                Affix affix = (Affix)Affix.REGISTRY.getValue(new ResourceLocation(key));
                if (affix == null) continue;
                float lvl = tag.func_74760_g(key);
                map.put(affix, Float.valueOf(lvl));
            }
        }
        return map;
    }

    public static void addLore(ItemStack stack, ITextComponent lore) {
        CompoundNBT display = stack.func_190925_c("display");
        ListNBT tag = display.func_150295_c("Lore", 8);
        tag.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)lore)));
        display.func_218657_a("Lore", (INBT)tag);
    }

    public static List<Affix> getAffixesFor(EquipmentType type) {
        ArrayList<Affix> affixes = new ArrayList<Affix>();
        Affix.REGISTRY.getValues().stream().filter(t -> t.canApply(type)).forEach(affixes::add);
        return affixes;
    }

    public static void setRarity(ItemStack stack, LootRarity rarity) {
        AffixHelper.addLore(stack, new TranslationTextComponent("rarity.apoth." + rarity.name().toLowerCase(Locale.ROOT), new Object[0]).func_150255_a(new Style().func_150238_a(rarity.getColor()).func_150217_b(Boolean.valueOf(true))));
        stack.func_196082_o().func_74778_a("apoth.rarity", rarity.name());
    }

    @Nullable
    public static LootRarity getRarity(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("apoth.rarity")) {
            try {
                return LootRarity.valueOf(stack.func_77978_p().func_74779_i("apoth.rarity"));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }
}

