/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix.impl.heavy;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.deadly.loot.EquipmentType;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.deadly.loot.affix.impl.RangedAffix;
import shadows.apotheosis.deadly.loot.modifiers.AffixModifier;

public class ExecuteAffix
extends RangedAffix {
    private static final DamageSource EXECUTION = new DamageSource("apoth.execute").func_76359_i().func_151518_m();

    public ExecuteAffix(int weight) {
        super(0.05f, 0.1f, weight);
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.AXE;
    }

    @Override
    public void onEntityDamaged(LivingEntity user, Entity target, float level) {
        LivingEntity living;
        if (target instanceof LivingEntity && (living = (LivingEntity)target).func_110143_aJ() / living.func_110138_aP() < level) {
            living.func_70097_a(EXECUTION, Float.MAX_VALUE);
        }
    }

    @Override
    public float apply(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        float lvl = this.range.func_186507_b(rand);
        if (modifier != null) {
            lvl = modifier.editLevel(this, lvl);
        }
        AffixHelper.addLore(stack, (ITextComponent)new TranslationTextComponent("affix." + this.getRegistryName() + ".desc", new Object[]{String.format("%.2f", Float.valueOf(lvl * 100.0f))}));
        return lvl;
    }

    @Override
    public float getMin() {
        return 0.03f;
    }

    @Override
    public float getMax() {
        return 0.2f;
    }
}

