/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.EnchModuleClient;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.altar.SeaAltarBlock;
import shadows.apotheosis.ench.altar.SeaAltarTile;
import shadows.apotheosis.ench.anvil.AnvilTile;
import shadows.apotheosis.ench.anvil.ApothAnvilBlock;
import shadows.apotheosis.ench.anvil.ApothAnvilItem;
import shadows.apotheosis.ench.anvil.ObliterationEnchant;
import shadows.apotheosis.ench.anvil.SplittingEnchant;
import shadows.apotheosis.ench.enchantments.BerserkersFuryEnchant;
import shadows.apotheosis.ench.enchantments.CrescendoEnchant;
import shadows.apotheosis.ench.enchantments.HellInfusionEnchantment;
import shadows.apotheosis.ench.enchantments.IcyThornsEnchant;
import shadows.apotheosis.ench.enchantments.KnowledgeEnchant;
import shadows.apotheosis.ench.enchantments.LifeMendingEnchant;
import shadows.apotheosis.ench.enchantments.MagicProtEnchant;
import shadows.apotheosis.ench.enchantments.MinersFervorEnchant;
import shadows.apotheosis.ench.enchantments.NaturesBlessingEnchant;
import shadows.apotheosis.ench.enchantments.ReboundingEnchant;
import shadows.apotheosis.ench.enchantments.ReflectiveEnchant;
import shadows.apotheosis.ench.enchantments.ScavengerEnchant;
import shadows.apotheosis.ench.enchantments.SeaInfusionEnchantment;
import shadows.apotheosis.ench.enchantments.ShieldBashEnchant;
import shadows.apotheosis.ench.enchantments.StableFootingEnchant;
import shadows.apotheosis.ench.enchantments.TemptingEnchant;
import shadows.apotheosis.ench.objects.ApothShearsItem;
import shadows.apotheosis.ench.objects.HellshelfBlock;
import shadows.apotheosis.ench.objects.HellshelfItem;
import shadows.apotheosis.ench.objects.ScrappingTomeItem;
import shadows.apotheosis.ench.objects.SeashelfBlock;
import shadows.apotheosis.ench.objects.SeashelfItem;
import shadows.apotheosis.ench.objects.TomeItem;
import shadows.apotheosis.ench.replacements.BaneEnchant;
import shadows.apotheosis.ench.replacements.DefenseEnchant;
import shadows.apotheosis.ench.table.ApothEnchantBlock;
import shadows.apotheosis.ench.table.ApothEnchantContainer;
import shadows.apotheosis.ench.table.ApothEnchantTile;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.util.EnchantmentIngredient;
import shadows.placebo.config.Configuration;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.util.PlaceboUtil;
import shadows.placebo.util.ReflectionHelper;

public class EnchModule {
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final List<TomeItem> TYPED_BOOKS = new LinkedList<TomeItem>();
    public static final DamageSource CORRUPTED = new DamageSource("apoth_corrupted").func_76348_h().func_151518_m();
    public static final EquipmentSlotType[] ARMOR = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    public static final EnchantmentType HOE = EnchantmentType.create((String)"HOE", i -> i instanceof HoeItem);
    public static final EnchantmentType SHIELD = EnchantmentType.create((String)"SHIELD", i -> i instanceof ShieldItem);
    public static final EnchantmentType ANVIL = EnchantmentType.create((String)"ANVIL", i -> i instanceof BlockItem && ((BlockItem)i).func_179223_d() instanceof AnvilBlock);
    static Configuration enchInfoConfig;
    Method dropLoot;
    final EquipmentSlotType[] slots = EquipmentSlotType.values();

    @SubscribeEvent
    public void init(Apotheosis.ApotheosisSetup e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "enchantment_module.cfg"));
        if (config.hasChanged()) {
            config.save();
        }
        config = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            String minF;
            int max = config.getInt("Max Level", ench.getRegistryName().toString(), EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment - normally " + ench.func_77325_b() + ".");
            int min = config.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (min > max) {
                min = max;
            }
            EnchantmentInfo info = new EnchantmentInfo(ench, max, min);
            String maxF = config.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = config.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
        }
        if (config.hasChanged()) {
            config.save();
        }
        enchInfoConfig = config;
        Ingredient pot = Apotheosis.potionIngredient(Potions.field_185220_C);
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.HELLSHELF, 3, 3, new Object[]{Blocks.field_196653_dH, Blocks.field_196653_dH, Blocks.field_196653_dH, Items.field_151072_bj, "forge:bookshelves", pot, Blocks.field_196653_dH, Blocks.field_196653_dH, Blocks.field_196653_dH});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PRISMATIC_WEB, 3, 3, new Object[]{null, Items.field_179562_cC, null, Items.field_179562_cC, Blocks.field_196553_aF, Items.field_179562_cC, null, Items.field_179562_cC, null});
        ItemStack book = new ItemStack((IItemProvider)Items.field_151122_aG);
        ItemStack stick = new ItemStack((IItemProvider)Items.field_151055_y);
        ItemStack blaze = new ItemStack((IItemProvider)Items.field_151072_bj);
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_HEAD_BOOK, 5), 3, 2, new Object[]{book, book, book, book, blaze, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_CHEST_BOOK, 8), 3, 3, new Object[]{book, blaze, book, book, book, book, book, book, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_LEGS_BOOK, 7), 3, 3, new Object[]{book, null, book, book, blaze, book, book, book, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_FEET_BOOK, 4), 3, 2, new Object[]{book, null, book, book, blaze, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.WEAPON_BOOK, 2), 1, 3, new Object[]{book, book, new ItemStack((IItemProvider)Items.field_151065_br)});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.DIGGER_BOOK, 3), 3, 3, new Object[]{book, book, book, null, blaze, null, null, stick, null});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.FISHING_ROD_BOOK, 2), 3, 3, new Object[]{null, null, blaze, null, stick, book, stick, null, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.BOW_BOOK, 3), 3, 3, new Object[]{null, stick, book, blaze, null, book, null, stick, book});
        Apotheosis.HELPER.addShapeless((Object)new ItemStack((IItemProvider)ApotheosisObjects.NULL_BOOK, 6), new Object[]{book, book, book, book, book, book, blaze});
        ItemStack msBrick = new ItemStack((IItemProvider)Blocks.field_196698_dj);
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PRISMATIC_ALTAR, 3, 3, new Object[]{msBrick, null, msBrick, msBrick, Items.field_221944_gd, msBrick, msBrick, Blocks.field_150381_bn, msBrick});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.SCRAP_TOME, 8), 3, 3, new Object[]{book, book, book, book, Blocks.field_150467_bQ, book, book, book, book});
        EnchantmentIngredient maxHellshelf = new EnchantmentIngredient((IItemProvider)ApotheosisObjects.HELLSHELF, ApotheosisObjects.HELL_INFUSION, Math.min(5, EnchModule.getEnchInfo(ApotheosisObjects.HELL_INFUSION).getMaxLevel()));
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.BLAZING_HELLSHELF, 3, 3, new Object[]{null, Items.field_151059_bz, null, Items.field_151059_bz, maxHellshelf, Items.field_151059_bz, Items.field_151065_br, Items.field_151065_br, Items.field_151065_br});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.GLOWING_HELLSHELF, 3, 3, new Object[]{null, Blocks.field_150426_aN, null, null, maxHellshelf, null, Blocks.field_150426_aN, null, Blocks.field_150426_aN});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.SEASHELF, 3, 3, new Object[]{Blocks.field_196779_gQ, Blocks.field_196779_gQ, Blocks.field_196779_gQ, Apotheosis.potionIngredient(Potions.field_185230_b), "forge:bookshelves", Items.field_196089_aZ, Blocks.field_196779_gQ, Blocks.field_196779_gQ, Blocks.field_196779_gQ});
        EnchantmentIngredient maxSeashelf = new EnchantmentIngredient((IItemProvider)ApotheosisObjects.SEASHELF, ApotheosisObjects.SEA_INFUSION, Math.min(5, EnchModule.getEnchInfo(ApotheosisObjects.SEA_INFUSION).getMaxLevel()));
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.CRYSTAL_SEASHELF, 3, 3, new Object[]{null, Items.field_179563_cD, null, null, maxSeashelf, null, Items.field_179563_cD, null, Items.field_179563_cD});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.HEART_SEASHELF, 3, 3, new Object[]{null, Items.field_205158_fa, null, Items.field_179562_cC, maxSeashelf, Items.field_179562_cC, Items.field_179562_cC, Items.field_179562_cC, Items.field_179562_cC});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.ENDSHELF, 3, 3, new Object[]{Blocks.field_196806_hJ, Blocks.field_196806_hJ, Blocks.field_196806_hJ, Items.field_185157_bK, "forge:bookshelves", Items.field_151079_bi, Blocks.field_196806_hJ, Blocks.field_196806_hJ, Blocks.field_196806_hJ});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PEARL_ENDSHELF, 3, 3, new Object[]{Items.field_221659_bR, null, Items.field_221659_bR, Items.field_151079_bi, ApotheosisObjects.ENDSHELF, Items.field_151079_bi, Items.field_221659_bR, null, Items.field_221659_bR});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.DRACONIC_ENDSHELF, 3, 3, new Object[]{null, Items.field_196151_dA, null, Items.field_151079_bi, ApotheosisObjects.ENDSHELF, Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.BEESHELF, 3, 3, new Object[]{Items.field_226635_pU_, Items.field_226637_pW_, Items.field_226635_pU_, Items.field_226639_pY_, "forge:bookshelves", Items.field_226639_pY_, Items.field_226635_pU_, Items.field_226637_pW_, Items.field_226635_pU_});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.MELONSHELF, 3, 3, new Object[]{Items.field_221794_dg, Items.field_221794_dg, Items.field_221794_dg, Items.field_151060_bw, "forge:bookshelves", Items.field_151060_bw, Items.field_221794_dg, Items.field_221794_dg, Items.field_221794_dg});
        Apotheosis.HELPER.addShaped((Object)Items.field_151062_by, 3, 3, new Object[]{Items.field_221695_cJ, "forge:gems/diamond", Items.field_221695_cJ, Items.field_151134_bR, Items.field_226638_pX_, Items.field_151134_bR, Items.field_221695_cJ, "forge:gems/diamond", Items.field_221695_cJ});
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.PRISMATIC_ALTAR);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.BLAZING_HELLSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.GLOWING_HELLSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.CRYSTAL_SEASHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.HEART_SEASHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.ENDSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.PEARL_ENDSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.DRACONIC_ENDSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.BEESHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.MELONSHELF);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.error("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable.", (Object)ench.getRegistryName(), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
    }

    @SubscribeEvent
    public void reloads(FMLServerAboutToStartEvent e) {
        e.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)EnchantingStatManager.INSTANCE);
    }

    @SubscribeEvent
    public void client(Apotheosis.ApotheosisClientSetup e) {
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleClient());
        EnchModuleClient.init();
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<TileEntityType<?>> e) {
        e.getRegistry().register(new TileEntityType(AnvilTile::new, (Set)ImmutableSet.of((Object)Blocks.field_150467_bQ, (Object)Blocks.field_196717_eY, (Object)Blocks.field_196718_eZ), null).setRegistryName("anvil"));
        e.getRegistry().register(new TileEntityType(SeaAltarTile::new, (Set)ImmutableSet.of((Object)((Object)ApotheosisObjects.PRISMATIC_ALTAR)), null).setRegistryName("prismatic_altar"));
        e.getRegistry().register(new TileEntityType(ApothEnchantTile::new, (Set)ImmutableSet.of((Object)Blocks.field_150381_bn), null).setRegistryName("minecraft:enchanting_table"));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<ContainerType<?>> e) {
        e.getRegistry().register(new ContainerType(ApothEnchantContainer::new).setRegistryName("enchanting"));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new SeaAltarBlock().setRegistryName("apotheosis", "prismatic_altar"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "anvil"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "chipped_anvil"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "damaged_anvil"), (Block)new HellshelfBlock().setRegistryName("hellshelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("blazing_hellshelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("glowing_hellshelf"), (Block)new SeashelfBlock().setRegistryName("seashelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("crystal_seashelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("heart_seashelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("endshelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("pearl_endshelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("draconic_endshelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)).setRegistryName("beeshelf"), (Block)new Block(Block.Properties.func_200945_a((Material)Material.field_151572_C).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)).setRegistryName("melonshelf")});
        PlaceboUtil.registerOverrideBlock((Block)((Block)new ApothEnchantBlock().setRegistryName("minecraft:enchanting_table")), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        Item oldShears = Items.field_151097_aZ;
        Item[] itemArray = new Item[27];
        ApothShearsItem shears = new ApothShearsItem();
        itemArray[0] = shears;
        itemArray[1] = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("apotheosis", "prismatic_web");
        itemArray[2] = new ApothAnvilItem(Blocks.field_150467_bQ);
        itemArray[3] = new ApothAnvilItem(Blocks.field_196717_eY);
        itemArray[4] = new ApothAnvilItem(Blocks.field_196718_eZ);
        itemArray[5] = new TomeItem(Items.field_190931_a, null);
        itemArray[6] = new TomeItem(Items.field_151161_ac, EnchantmentType.ARMOR_HEAD);
        itemArray[7] = new TomeItem(Items.field_151163_ad, EnchantmentType.ARMOR_CHEST);
        itemArray[8] = new TomeItem(Items.field_151173_ae, EnchantmentType.ARMOR_LEGS);
        itemArray[9] = new TomeItem(Items.field_151175_af, EnchantmentType.ARMOR_FEET);
        itemArray[10] = new TomeItem(Items.field_151048_u, EnchantmentType.WEAPON);
        itemArray[11] = new TomeItem(Items.field_151046_w, EnchantmentType.DIGGER);
        itemArray[12] = new TomeItem(Items.field_151112_aM, EnchantmentType.FISHING_ROD);
        itemArray[13] = new TomeItem(Items.field_151031_f, EnchantmentType.BOW);
        itemArray[14] = (Item)new BlockItem((Block)ApotheosisObjects.PRISMATIC_ALTAR, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("prismatic_altar");
        itemArray[15] = new ScrappingTomeItem();
        itemArray[16] = (Item)new HellshelfItem(ApotheosisObjects.HELLSHELF).setRegistryName(ApotheosisObjects.HELLSHELF.getRegistryName());
        itemArray[17] = (Item)new BlockItem(ApotheosisObjects.BLAZING_HELLSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("blazing_hellshelf");
        itemArray[18] = (Item)new BlockItem(ApotheosisObjects.GLOWING_HELLSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("glowing_hellshelf");
        itemArray[19] = (Item)new SeashelfItem(ApotheosisObjects.SEASHELF).setRegistryName(ApotheosisObjects.SEASHELF.getRegistryName());
        itemArray[20] = (Item)new BlockItem(ApotheosisObjects.CRYSTAL_SEASHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("crystal_seashelf");
        itemArray[21] = (Item)new BlockItem(ApotheosisObjects.HEART_SEASHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("heart_seashelf");
        itemArray[22] = (Item)new BlockItem(ApotheosisObjects.ENDSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("endshelf");
        itemArray[23] = (Item)new BlockItem(ApotheosisObjects.DRACONIC_ENDSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("draconic_endshelf");
        itemArray[24] = (Item)new BlockItem(ApotheosisObjects.PEARL_ENDSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("pearl_endshelf");
        itemArray[25] = (Item)new BlockItem(ApotheosisObjects.BEESHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("beeshelf");
        itemArray[26] = (Item)new BlockItem(ApotheosisObjects.MELONSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("melonshelf");
        e.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
        DispenserBlock.func_199774_a((IItemProvider)shears, (IDispenseItemBehavior)((IDispenseItemBehavior)DispenserBlock.field_149943_a.get(oldShears)));
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{(Enchantment)new HellInfusionEnchantment().setRegistryName("apotheosis", "hell_infusion"), (Enchantment)new MinersFervorEnchant().setRegistryName("apotheosis", "depth_miner"), (Enchantment)new StableFootingEnchant().setRegistryName("apotheosis", "stable_footing"), (Enchantment)new ScavengerEnchant().setRegistryName("apotheosis", "scavenger"), (Enchantment)new LifeMendingEnchant().setRegistryName("apotheosis", "life_mending"), (Enchantment)new IcyThornsEnchant().setRegistryName("apotheosis", "icy_thorns"), (Enchantment)new TemptingEnchant().setRegistryName("apotheosis", "tempting"), (Enchantment)new ShieldBashEnchant().setRegistryName("apotheosis", "shield_bash"), (Enchantment)new ReflectiveEnchant().setRegistryName("apotheosis", "reflective"), (Enchantment)new BerserkersFuryEnchant().setRegistryName("apotheosis", "berserk"), (Enchantment)new KnowledgeEnchant().setRegistryName("apotheosis", "knowledge"), (Enchantment)new SplittingEnchant().setRegistryName("apotheosis", "splitting"), (Enchantment)new NaturesBlessingEnchant().setRegistryName("apotheosis", "natures_blessing"), (Enchantment)new ReboundingEnchant().setRegistryName("apotheosis", "rebounding"), (Enchantment)new MagicProtEnchant().setRegistryName("apotheosis", "magic_protection"), (Enchantment)new SeaInfusionEnchantment().setRegistryName("sea_infusion"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, CreatureAttribute.field_223224_c_, EquipmentSlotType.MAINHAND).setRegistryName("minecraft", "bane_of_arthropods"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, CreatureAttribute.field_223223_b_, EquipmentSlotType.MAINHAND).setRegistryName("minecraft", "smite"), (Enchantment)new BaneEnchant(Enchantment.Rarity.COMMON, CreatureAttribute.field_223222_a_, EquipmentSlotType.MAINHAND).setRegistryName("minecraft", "sharpness"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, CreatureAttribute.field_223225_d_, EquipmentSlotType.MAINHAND).setRegistryName("bane_of_illagers"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.COMMON, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "fire_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.RARE, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "blast_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "projectile_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.ALL, EquipmentSlotType.FEET).setRegistryName("minecraft", "feather_falling"), (Enchantment)new ObliterationEnchant().setRegistryName("obliteration"), (Enchantment)new CrescendoEnchant().setRegistryName("crescendo")});
    }

    @SubscribeEvent
    public void sounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().register(new SoundEvent(new ResourceLocation("apotheosis", "altar")).setRegistryName("apotheosis", "altar_sound"));
    }

    @SubscribeEvent
    public void anvilEvent(AnvilUpdateEvent e) {
        if (!EnchantmentHelper.func_82781_a((ItemStack)e.getLeft()).isEmpty()) {
            if (e.getRight().func_77973_b() == Items.field_221672_ax) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> ((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(ent -> (Enchantment)ent.getKey(), ent -> (Integer)ent.getValue())), (ItemStack)stack);
                e.setCost(1);
                e.setMaterialCost(1);
                e.setOutput(stack);
            } else if (e.getRight().func_77973_b() == ApotheosisObjects.PRISMATIC_WEB) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> !((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(ent -> (Enchantment)ent.getKey(), ent -> (Integer)ent.getValue())), (ItemStack)stack);
                e.setCost(30);
                e.setMaterialCost(1);
                e.setOutput(stack);
                return;
            }
        }
        if ((e.getLeft().func_77973_b() == Items.field_221846_eg || e.getLeft().func_77973_b() == Items.field_221848_eh) && e.getRight().func_77973_b().func_206844_a(Tags.Items.STORAGE_BLOCKS_IRON)) {
            if (e.getLeft().func_190916_E() != 1) {
                return;
            }
            int dmg = e.getLeft().func_77973_b() == Items.field_221848_eh ? 2 : 1;
            ItemStack out = new ItemStack((IItemProvider)(dmg == 1 ? Items.field_221844_ef : Items.field_221846_eg));
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)e.getLeft()), (ItemStack)out);
            out.func_190920_e(1);
            e.setOutput(out);
            e.setCost(5 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)e.getLeft()) + EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SPLITTING, (ItemStack)e.getLeft()) * 2);
            e.setMaterialCost(1);
            return;
        }
        if (e.getLeft().func_77973_b() == ApotheosisObjects.HELLSHELF.func_199767_j() || e.getLeft().func_77973_b() == ApotheosisObjects.SEASHELF.func_199767_j()) {
            if (e.getLeft().func_77973_b() != e.getRight().func_77973_b() || e.getLeft().func_190916_E() != 1) {
                return;
            }
            Enchantment ench = e.getLeft().func_77973_b() == ApotheosisObjects.HELLSHELF.func_199767_j() ? ApotheosisObjects.HELL_INFUSION : ApotheosisObjects.SEA_INFUSION;
            int leftLvl = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)e.getLeft());
            int rightLvl = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)e.getRight());
            if (leftLvl == 0 || rightLvl != leftLvl) {
                return;
            }
            if (leftLvl + 1 > EnchModule.getEnchInfo(ench).getMaxLevel()) {
                return;
            }
            ItemStack out = e.getLeft().func_77946_l();
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)ench, (Object)(leftLvl + 1)), (ItemStack)out);
            out.func_190920_e(1);
            e.setOutput(out);
            e.setCost(1 + leftLvl);
            e.setMaterialCost(1);
            return;
        }
        if (ScrappingTomeItem.updateAnvil(e)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) throws Exception {
        Entity attacker = e.getSource().func_76346_g();
        if (attacker instanceof PlayerEntity) {
            int knowledge;
            PlayerEntity p = (PlayerEntity)attacker;
            if (p.field_70170_p.field_72995_K) {
                return;
            }
            int scavenger = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SCAVENGER, (ItemStack)p.func_184614_ca());
            if (scavenger > 0 && (float)p.field_70170_p.field_73012_v.nextInt(100) < (float)scavenger * 2.5f) {
                if (this.dropLoot == null) {
                    this.dropLoot = ReflectionHelper.findMethod(LivingEntity.class, (String)"dropLoot", (String)"func_213354_a", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
                }
                this.dropLoot.invoke((Object)e.getEntityLiving(), e.getSource(), true);
            }
            if ((knowledge = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.KNOWLEDGE, (ItemStack)p.func_184614_ca())) > 0 && !(e.getEntity() instanceof PlayerEntity)) {
                int items = 0;
                for (ItemEntity i : e.getDrops()) {
                    items += i.func_92059_d().func_190916_E();
                }
                if (items > 0) {
                    e.getDrops().clear();
                }
                items *= knowledge * 25;
                LivingEntity ded = e.getEntityLiving();
                while (items > 0) {
                    int i = ExperienceOrbEntity.func_70527_a((int)items);
                    items -= i;
                    p.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(p.field_70170_p, ded.func_226277_ct_(), ded.func_226278_cu_(), ded.func_226281_cx_(), i));
                }
            }
        }
    }

    @SubscribeEvent
    public void lifeMend(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity().field_70170_p.field_72995_K || e.getEntity().field_70173_aa % 20 != 0) {
            return;
        }
        for (EquipmentSlotType slot : this.slots) {
            int level;
            ItemStack stack = e.getEntityLiving().func_184582_a(slot);
            if (stack.func_190926_b() || !stack.func_77951_h() || (level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.LIFE_MENDING, (ItemStack)stack)) <= 0) continue;
            int i = Math.min(level, stack.func_77952_i());
            e.getEntityLiving().func_70097_a(CORRUPTED, (float)i * 0.7f);
            stack.func_196085_b(stack.func_77952_i() - i);
            return;
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        ItemStack stack;
        PlayerEntity p = e.getPlayer();
        if (!p.field_70122_E && EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.STABLE_FOOTING, (LivingEntity)p) > 0 && e.getOriginalSpeed() < e.getNewSpeed() * 5.0f) {
            e.setNewSpeed(e.getNewSpeed() * 5.0f);
        }
        if ((stack = p.func_184614_ca()).func_190926_b()) {
            return;
        }
        int depth = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.DEPTH_MINER, (ItemStack)stack);
        if (depth > 0 && stack.func_150997_a(e.getState()) > 1.0f) {
            float hardness = e.getState().func_185887_b((IBlockReader)e.getPlayer().field_70170_p, e.getPos());
            e.setNewSpeed(Math.min(29.99f, 7.5f + 4.5f * (float)depth) * hardness);
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock e) {
        ItemStack s = e.getItemStack();
        int nbLevel = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.NATURES_BLESSING, (ItemStack)s);
        if (!e.getEntity().func_225608_bj_() && nbLevel > 0 && BoneMealItem.applyBonemeal((ItemStack)s.func_77946_l(), (World)e.getWorld(), (BlockPos)e.getPos(), (PlayerEntity)e.getPlayer())) {
            s.func_222118_a(6 - nbLevel, (LivingEntity)e.getPlayer(), ent -> ent.func_213334_d(e.getHand()));
            e.setCanceled(true);
            e.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void applyUnbreaking(AnvilRepairEvent e) {
        if (e.getPlayer().field_71070_bA instanceof RepairContainer) {
            RepairContainer r = (RepairContainer)e.getPlayer().field_71070_bA;
            TileEntity te = r.field_216980_g.func_221484_a((w, p) -> w.func_175625_s(p)).orElse(null);
            if (te instanceof AnvilTile) {
                e.setBreakChance(e.getBreakChance() / (float)(((AnvilTile)te).getEnchantments().getInt((Object)Enchantments.field_185307_s) + 1));
            }
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent e) {
        LivingEntity src;
        int lvl;
        int level;
        LivingEntity user = e.getEntityLiving();
        if (e.getSource().func_76346_g() instanceof Entity && user.func_70660_b(Effects.field_76429_m) == null && (level = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.BERSERK, (LivingEntity)user)) > 0) {
            user.func_70097_a(CORRUPTED, (float)(level * level));
            user.func_195064_c(new EffectInstance(Effects.field_76429_m, 200 * level, level - 1));
            user.func_195064_c(new EffectInstance(Effects.field_76420_g, 200 * level, level - 1));
            user.func_195064_c(new EffectInstance(Effects.field_76424_c, 200 * level, level - 1));
        }
        if (e.getSource().func_82725_o() && e.getSource().func_76346_g() instanceof LivingEntity && (lvl = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.MAGIC_PROTECTION, (LivingEntity)(src = (LivingEntity)e.getSource().func_76346_g()))) > 0) {
            e.setAmount(CombatRules.func_188401_b((float)e.getAmount(), (float)EnchantmentHelper.func_77508_a((Iterable)src.func_184193_aE(), (DamageSource)e.getSource())));
        }
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (!Apotheosis.enableEnch) {
            return ENCHANTMENT_INFO.computeIfAbsent(ench, e -> new EnchantmentInfo((Enchantment)e, e.func_77325_b(), e.func_77319_d()));
        }
        if (enchInfoConfig == null) {
            LOGGER.error("A mod has attempted to access enchantment information before Apotheosis init, this should not happen.");
            Thread.dumpStack();
            return new EnchantmentInfo(ench, ench.func_77325_b(), ench.func_77319_d());
        }
        if (info == null) {
            String minF;
            int max = enchInfoConfig.getInt("Max Level", ench.getRegistryName().toString(), EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment - normally " + ench.func_77325_b() + ".");
            int min = enchInfoConfig.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (min > max) {
                min = max;
            }
            info = new EnchantmentInfo(ench, max, min);
            String maxF = enchInfoConfig.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = enchInfoConfig.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)ench.getRegistryName(), (Object)ench.getRegistryName().func_110624_b());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.func_77325_b();
        if (level == 1) {
            return 1;
        }
        int minPower = ench.func_77321_a(level);
        if (minPower >= 150) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < 150) {
            int diff = ench.func_77321_a(++level) - ench.func_77321_a(level - 1);
            int n = minPower = level > ench.func_77325_b() ? ench.func_77321_a(level) + diff * (int)Math.pow(level - ench.func_77325_b(), 1.6) : ench.func_77321_a(level);
            if (lastPower == minPower) {
                --level;
                break;
            }
            lastPower = minPower;
        }
        return level;
    }
}

