/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.altar;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.ItemStackHandler;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.altar.IntCollector;
import shadows.apotheosis.util.ParticleMessage;
import shadows.placebo.recipe.VanillaPacketDispatcher;
import shadows.placebo.util.EnchantmentUtils;
import shadows.placebo.util.NetworkUtils;

public class SeaAltarTile
extends TileEntity
implements ITickableTileEntity {
    private Random rand = new Random();
    protected ItemStackHandler inv = new ItemStackHandler(5);
    protected float xpDrained = 0.0f;
    protected ItemStack target = ItemStack.field_190927_a;
    protected float targetXP = 0.0f;
    int soundTick = 0;
    double[][] offsets = new double[][]{{0.1875, 0.1875}, {0.1875, 0.8125}, {0.8125, 0.1875}, {0.8125, 0.8125}};

    public SeaAltarTile() {
        super(ApotheosisObjects.ALTAR_TYPE);
    }

    public void func_73660_a() {
        int i;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.inv.getStackInSlot(4).func_190926_b()) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            if (!this.inv.getStackInSlot(i).func_190926_b()) continue;
            this.target = ItemStack.field_190927_a;
            this.targetXP = 0.0f;
            return;
        }
        if (!this.target.func_190926_b()) {
            this.drainXP();
            if (this.xpDrained >= this.targetXP) {
                this.inv.setStackInSlot(4, this.target);
                this.target = ItemStack.field_190927_a;
                this.targetXP = 0.0f;
                this.xpDrained = 0.0f;
                for (i = 0; i < 4; ++i) {
                    this.inv.setStackInSlot(i, ItemStack.field_190927_a);
                }
                this.markAndNotify();
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            this.findTarget(this.calcProvidedEnchValue());
        }
    }

    public int calcProvidedEnchValue() {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value += EnchantmentHelper.func_82781_a((ItemStack)this.inv.getStackInSlot(i)).entrySet().stream().map(this::getValueForEnch).collect(IntCollector.INSTANCE).intValue();
        }
        return value;
    }

    public int getValueForEnch(Map.Entry<Enchantment, Integer> ench) {
        if (ench.getKey() == null) {
            return 0;
        }
        EnchantmentInfo info = EnchModule.getEnchInfo(ench.getKey());
        double avg = (double)(info.getMaxPower(ench.getValue()) + info.getMinPower(ench.getValue())) / 2.5;
        return (int)Math.floor(avg / 4.0);
    }

    public void drainXP() {
        List nearby = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(5.0, 5.0, 5.0));
        boolean removed = false;
        for (PlayerEntity p : nearby) {
            int maxDrain = (int)Math.ceil(this.targetXP / 200.0f);
            int removable = Math.min(1 + maxDrain, p.field_71067_cb);
            EnchantmentUtils.addPlayerXP((PlayerEntity)p, (int)(-removable));
            this.xpDrained += (float)removable;
            if (removable <= 0) continue;
            this.trySpawnParticles(p, removable);
            removed = true;
        }
        if (this.soundTick++ % 50 == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ApotheosisObjects.ALTAR_SOUND, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
        if (!removed && this.soundTick % 10 == 0) {
            for (int i = 0; i < 4; ++i) {
                ParticleMessage msg = new ParticleMessage((ParticleType<?>)ParticleTypes.field_197607_R, (double)this.field_174879_c.func_177958_n() + this.offsets[i][0], (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + this.offsets[i][1], 0.0, 0.1, 0.0, 1);
                NetworkUtils.sendToTracking((SimpleChannel)Apotheosis.CHANNEL, (Object)((Object)msg), (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c);
            }
        }
    }

    public void findTarget(int value) {
        value = Math.min(value, 85);
        ItemStack book = new ItemStack((IItemProvider)Items.field_151122_aG);
        this.target = new ItemStack((IItemProvider)Items.field_151134_bR);
        this.targetXP = EnchantmentUtils.getExperienceForLevel((int)(value / 2));
        long seed = 1831L;
        for (int i = 0; i < 4; ++i) {
            for (Enchantment e : EnchantmentHelper.func_82781_a((ItemStack)this.inv.getStackInSlot(i)).keySet()) {
                seed ^= (long)e.getRegistryName().hashCode();
            }
        }
        this.rand.setSeed(seed);
        int half = value / 2;
        List datas = EnchantmentHelper.func_77513_b((Random)this.rand, (ItemStack)book, (int)value, (boolean)true);
        while (datas.isEmpty() && value >= half) {
            datas = EnchantmentHelper.func_77513_b((Random)this.rand, (ItemStack)book, (int)(value -= 5), (boolean)true);
        }
        if (!datas.isEmpty()) {
            for (EnchantmentData d : datas) {
                EnchantedBookItem.func_92115_a((ItemStack)this.target, (EnchantmentData)d);
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ApotheosisObjects.ALTAR_SOUND, SoundCategory.BLOCKS, 0.5f, 1.0f);
            this.soundTick = 0;
        } else {
            this.target = ItemStack.field_190927_a;
            this.targetXP = 0.0f;
        }
    }

    public void trySpawnParticles(PlayerEntity player, int xpDrain) {
        Vec3d to = new Vec3d(player.func_226277_ct_() - ((double)this.field_174879_c.func_177958_n() + 0.5), player.func_226278_cu_() - (double)this.field_174879_c.func_177956_o(), player.func_226281_cx_() - ((double)this.field_174879_c.func_177952_p() + 0.5));
        ParticleMessage msg = new ParticleMessage((ParticleType<?>)ParticleTypes.field_197623_p, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)(this.field_174879_c.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), to.field_72450_a, to.field_72448_b, to.field_72449_c, Math.min(5, xpDrain));
        NetworkUtils.sendToTracking((SimpleChannel)Apotheosis.CHANNEL, (Object)((Object)msg), (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inv.serializeNBT());
        tag.func_74776_a("xp", this.xpDrained);
        tag.func_218657_a("target", (INBT)this.target.serializeNBT());
        tag.func_74776_a("targetXP", this.targetXP);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
        this.xpDrained = tag.func_74760_g("xp");
        this.target = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("target"));
        this.targetXP = tag.func_74760_g("targetXP");
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("inv", (INBT)this.inv.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public void markAndNotify() {
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }
}

