/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.ench.table.ApothEnchantContainer;

public class RealEnchantmentHelper {
    public static int calcSlotLevel(Random rand, int num, float power, ItemStack stack) {
        int ench = stack.getItemEnchantability();
        if (ench <= 0) {
            return 0;
        }
        int level = (int)(power * 2.0f);
        if (num == 2) {
            return level;
        }
        float lowBound = 0.6f - 0.4f * (float)(1 - num) + (float)ench / 200.0f;
        float highBound = 0.8f - 0.4f * (float)(1 - num) + (float)ench / 200.0f;
        return (int)((float)level * MathHelper.func_151240_a((Random)rand, (float)lowBound, (float)highBound));
    }

    public static List<EnchantmentData> buildEnchantmentList(Random rand, ItemStack stack, int power, float quanta, float arcanaLevel, boolean treasure) {
        ArrayList chosenEnchants = Lists.newArrayList();
        int enchantability = stack.getItemEnchantability();
        if (enchantability <= 0) {
            return chosenEnchants;
        }
        power += rand.nextInt(Math.max(enchantability / 2, 1));
        float factor = MathHelper.func_151240_a((Random)rand, (float)-1.0f, (float)1.0f) * quanta / 10.0f;
        power = MathHelper.func_76125_a((int)Math.round((float)power + (float)power * factor), (int)1, (int)200);
        ApothEnchantContainer.Arcana arcana = ApothEnchantContainer.Arcana.getForThreshold(arcanaLevel);
        List<EnchantmentData> allEnchants = RealEnchantmentHelper.getEnchantmentDatas(power, stack, treasure);
        List<ArcanaEnchantmentData> possibleEnchants = allEnchants.stream().map(d -> new ArcanaEnchantmentData(arcana, (EnchantmentData)d)).collect(Collectors.toList());
        if (!possibleEnchants.isEmpty()) {
            chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
            RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentData)Util.func_223378_a((List)chosenEnchants));
            if (arcanaLevel >= 2.5f && !possibleEnchants.isEmpty()) {
                chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
                RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentData)Util.func_223378_a((List)chosenEnchants));
            }
            if (arcanaLevel >= 7.5f && !possibleEnchants.isEmpty()) {
                chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
            }
            while (arcanaLevel + (float)rand.nextInt(50) <= (float)power) {
                RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentData)Util.func_223378_a((List)chosenEnchants));
                if (possibleEnchants.isEmpty()) break;
                chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
                power /= 2;
            }
        }
        return chosenEnchants;
    }

    public static void removeIncompatible(List<ArcanaEnchantmentData> list, EnchantmentData data) {
        Iterator<ArcanaEnchantmentData> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (data.field_76302_b.func_191560_c(iterator.next().data.field_76302_b)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentData> getEnchantmentDatas(int power, ItemStack stack, boolean treasure) {
        return EnchHooks.getEnchantmentDatas(power, stack, treasure);
    }

    private static class ArcanaEnchantmentData
    extends WeightedRandom.Item {
        EnchantmentData data;

        private ArcanaEnchantmentData(ApothEnchantContainer.Arcana arcana, EnchantmentData data) {
            super(arcana.getRarities()[data.field_76302_b.func_77324_c().ordinal()]);
            this.data = data;
        }
    }
}

