/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.garden;

import java.io.File;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BambooLeaves;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BambooFeature;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.garden.ApothBambooBlock;
import shadows.apotheosis.garden.ApothCactusBlock;
import shadows.apotheosis.garden.ApothSugarcaneBlock;
import shadows.apotheosis.garden.EnderLeashItem;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class GardenModule {
    public static int maxCactusHeight = 5;
    public static int maxReedHeight = 255;
    public static int maxBambooHeight = 32;

    @SubscribeEvent
    public void setup(Apotheosis.ApotheosisSetup e) {
        Configuration c = new Configuration(new File(Apotheosis.configDir, "garden.cfg"));
        maxCactusHeight = c.getInt("Cactus Height", "general", maxCactusHeight, 1, 255, "The max height a stack of cacti may grow to.  Vanilla is 3.");
        maxReedHeight = c.getInt("Reed Height", "general", maxReedHeight, 1, 255, "The max height a stack of reeds may grow to.  Vanilla is 3.");
        maxBambooHeight = c.getInt("Bamboo Height", "general", maxBambooHeight, 1, 255, "The max height a stack of bamboo may grow to.  Vanilla is 16.");
        if (c.hasChanged()) {
            c.save();
        }
        Apotheosis.HELPER.addShapeless((Object)ApotheosisObjects.FARMERS_LEASH, new Object[]{Items.field_151079_bi, Items.field_151058_ca, Items.field_151043_k});
        GardenModule.fix(DefaultBiomeFeatures.field_226730_R_, Blocks.field_196608_cF);
        GardenModule.fix(DefaultBiomeFeatures.field_226729_Q_, Blocks.field_150434_aF);
        BambooFeature.field_214566_a = (BlockState)((BlockState)((BlockState)Blocks.field_222405_kQ.func_176223_P().func_206870_a((IProperty)BambooBlock.field_220264_d, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)BambooBlock.field_220265_e, (Comparable)BambooLeaves.NONE)).func_206870_a((IProperty)BambooBlock.field_220266_f, (Comparable)Integer.valueOf(0));
        BambooFeature.field_214567_aS = (BlockState)((BlockState)BambooFeature.field_214566_a.func_206870_a((IProperty)BambooBlock.field_220265_e, (Comparable)BambooLeaves.LARGE)).func_206870_a((IProperty)BambooBlock.field_220266_f, (Comparable)Integer.valueOf(1));
        BambooFeature.field_214568_aT = (BlockState)BambooFeature.field_214566_a.func_206870_a((IProperty)BambooBlock.field_220265_e, (Comparable)BambooLeaves.LARGE);
        BambooFeature.field_214569_aU = (BlockState)BambooFeature.field_214566_a.func_206870_a((IProperty)BambooBlock.field_220265_e, (Comparable)BambooLeaves.SMALL);
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverrideBlock((Block)new ApothCactusBlock(), (String)"apotheosis");
        PlaceboUtil.registerOverrideBlock((Block)new ApothSugarcaneBlock(), (String)"apotheosis");
        PlaceboUtil.registerOverrideBlock((Block)new ApothBambooBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new EnderLeashItem().setRegistryName("farmers_leash"));
        ComposterBlock.field_220299_b.put((Object)Blocks.field_150434_aF.func_199767_j(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)Blocks.field_196608_cF.func_199767_j(), 0.5f);
    }

    private static void fix(BlockClusterFeatureConfig cfg, Block newBlock) {
        ObfuscationReflectionHelper.setPrivateValue(BlockClusterFeatureConfig.class, (Object)cfg, (Object)new SimpleBlockStateProvider(newBlock.func_176223_P()), (String)"field_227289_a_");
    }
}

