/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Size2i;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.potion.PotionCharmRecipe;

@JeiPlugin
public class PotionJEIPlugin
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        reg.getCraftingCategory().addCategoryExtension(PotionCharmRecipe.class, x$0 -> new PotionCharmRecipeWrapper((PotionCharmRecipe)((Object)x$0)));
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "potion");
    }

    private class PotionCharmRecipeWrapper
    implements ICraftingCategoryExtension {
        private final PotionCharmRecipe recipe;

        PotionCharmRecipeWrapper(PotionCharmRecipe recipe) {
            this.recipe = recipe;
        }

        public void setIngredients(IIngredients ing) {
            ing.setInputLists(VanillaTypes.ITEM, this.recipe.func_192400_c().stream().map(i -> i.func_193365_a()).map(a -> Arrays.asList(a)).collect(Collectors.toList()));
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (ItemStack s : ((Ingredient)this.recipe.func_192400_c().get(4)).func_193365_a()) {
                ItemStack out = new ItemStack((IItemProvider)ApotheosisObjects.POTION_CHARM);
                PotionUtils.func_185188_a((ItemStack)out, (Potion)PotionUtils.func_185191_c((ItemStack)s));
                AffixHelper.addLore(out, (ITextComponent)new TranslationTextComponent("info.apotheosis.req_3_potions", new Object[0]));
                outputs.add(out);
            }
            ing.setOutputLists(VanillaTypes.ITEM, Arrays.asList(outputs));
        }

        public ResourceLocation getRegistryName() {
            return this.recipe.func_199560_c();
        }

        public Size2i getSize() {
            return new Size2i(3, 3);
        }
    }
}

