/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import shadows.apotheosis.Apotheosis;

public class ModuleCondition
implements ICondition {
    static ResourceLocation id = new ResourceLocation("apotheosis", "module");
    static Map<String, Supplier<Boolean>> types = new HashMap<String, Supplier<Boolean>>();
    final String name;

    public ModuleCondition(String name) {
        this.name = name;
    }

    public ResourceLocation getID() {
        return id;
    }

    public boolean test() {
        return types.get(this.name).get();
    }

    static {
        types.put("spawner", () -> Apotheosis.enableSpawner);
        types.put("garden", () -> Apotheosis.enableGarden);
        types.put("deadly", () -> Apotheosis.enableDeadly);
        types.put("enchantment", () -> Apotheosis.enableEnch);
        types.put("potion", () -> Apotheosis.enablePotion);
        types.put("villager", () -> Apotheosis.enableVillager);
    }

    public static class Serializer
    implements IConditionSerializer<ModuleCondition> {
        public void write(JsonObject json, ModuleCondition value) {
            json.addProperty("field", value.name);
        }

        public ModuleCondition read(JsonObject json) {
            if (!json.has("module") || !types.containsKey(json.get("module").getAsString())) {
                throw new JsonParseException("Invalid module condition!");
            }
            return new ModuleCondition(json.get("module").getAsString());
        }

        public ResourceLocation getID() {
            return id;
        }
    }
}

